@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.digitaltwins.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes a time series database connection resource.
 * @property id The resource identifier.
 * @property name Extension resource name.
 * @property properties Properties of a specific time series database connection.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The resource type.
 */
public data class GetTimeSeriesDatabaseConnectionResult(
    public val id: String,
    public val name: String,
    public val properties: AzureDataExplorerConnectionPropertiesResponse,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.digitaltwins.outputs.GetTimeSeriesDatabaseConnectionResult):
            GetTimeSeriesDatabaseConnectionResult = GetTimeSeriesDatabaseConnectionResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.digitaltwins.kotlin.outputs.AzureDataExplorerConnectionPropertiesResponse.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.digitaltwins.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
