@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.ClusterResourceResponseProperties
import com.pulumi.azurenative.documentdb.kotlin.outputs.ManagedCassandraManagedServiceIdentityResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.documentdb.kotlin.outputs.ClusterResourceResponseProperties.Companion.toKotlin as clusterResourceResponsePropertiesToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.ManagedCassandraManagedServiceIdentityResponse.Companion.toKotlin as managedCassandraManagedServiceIdentityResponseToKotlin

/**
 * Builder for [CassandraCluster].
 */
@PulumiTagMarker
public class CassandraClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CassandraClusterArgs = CassandraClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CassandraClusterArgsBuilder.() -> Unit) {
        val builder = CassandraClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CassandraCluster {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.CassandraCluster(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CassandraCluster(builtJavaResource)
    }
}

/**
 * Representation of a managed Cassandra cluster.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2021-07-01-preview, 2023-09-15, 2023-09-15-preview.
 * ## Example Usage
 * ### CosmosDBManagedCassandraClusterCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cassandraCluster = new AzureNative.DocumentDB.CassandraCluster("cassandraCluster", new()
 *     {
 *         ClusterName = "cassandra-prod",
 *         Location = "West US",
 *         Properties = new AzureNative.DocumentDB.Inputs.ClusterResourcePropertiesArgs
 *         {
 *             AuthenticationMethod = "Cassandra",
 *             CassandraVersion = "3.11",
 *             ClientCertificates = new[]
 *             {
 *                 new AzureNative.DocumentDB.Inputs.CertificateArgs
 *                 {
 *                     Pem = @"-----BEGIN CERTIFICATE-----
 * ...Base64 encoded certificate...
 * -----END CERTIFICATE-----",
 *                 },
 *             },
 *             ClusterNameOverride = "ClusterNameIllegalForAzureResource",
 *             DelegatedManagementSubnetId = "/subscriptions/536e130b-d7d6-4ac7-98a5-de20d69588d2/resourceGroups/customer-vnet-rg/providers/Microsoft.Network/virtualNetworks/customer-vnet/subnets/management",
 *             ExternalGossipCertificates = new[]
 *             {
 *                 new AzureNative.DocumentDB.Inputs.CertificateArgs
 *                 {
 *                     Pem = @"-----BEGIN CERTIFICATE-----
 * ...Base64 encoded certificate...
 * -----END CERTIFICATE-----",
 *                 },
 *             },
 *             ExternalSeedNodes = new[]
 *             {
 *                 new AzureNative.DocumentDB.Inputs.SeedNodeArgs
 *                 {
 *                     IpAddress = "10.52.221.2",
 *                 },
 *                 new AzureNative.DocumentDB.Inputs.SeedNodeArgs
 *                 {
 *                     IpAddress = "10.52.221.3",
 *                 },
 *                 new AzureNative.DocumentDB.Inputs.SeedNodeArgs
 *                 {
 *                     IpAddress = "10.52.221.4",
 *                 },
 *             },
 *             HoursBetweenBackups = 24,
 *             InitialCassandraAdminPassword = "mypassword",
 *         },
 *         ResourceGroupName = "cassandra-prod-rg",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewCassandraCluster(ctx, "cassandraCluster", &documentdb.CassandraClusterArgs{
 * 			ClusterName: pulumi.String("cassandra-prod"),
 * 			Location:    pulumi.String("West US"),
 * 			Properties: documentdb.ClusterResourceResponseProperties{
 * 				AuthenticationMethod: pulumi.String("Cassandra"),
 * 				CassandraVersion:     pulumi.String("3.11"),
 * 				ClientCertificates: documentdb.CertificateArray{
 * 					&documentdb.CertificateArgs{
 * 						Pem: pulumi.String("-----BEGIN CERTIFICATE-----\n...Base64 encoded certificate...\n-----END CERTIFICATE-----"),
 * 					},
 * 				},
 * 				ClusterNameOverride:         pulumi.String("ClusterNameIllegalForAzureResource"),
 * 				DelegatedManagementSubnetId: pulumi.String("/subscriptions/536e130b-d7d6-4ac7-98a5-de20d69588d2/resourceGroups/customer-vnet-rg/providers/Microsoft.Network/virtualNetworks/customer-vnet/subnets/management"),
 * 				ExternalGossipCertificates: documentdb.CertificateArray{
 * 					&documentdb.CertificateArgs{
 * 						Pem: pulumi.String("-----BEGIN CERTIFICATE-----\n...Base64 encoded certificate...\n-----END CERTIFICATE-----"),
 * 					},
 * 				},
 * 				ExternalSeedNodes: documentdb.SeedNodeArray{
 * 					&documentdb.SeedNodeArgs{
 * 						IpAddress: pulumi.String("10.52.221.2"),
 * 					},
 * 					&documentdb.SeedNodeArgs{
 * 						IpAddress: pulumi.String("10.52.221.3"),
 * 					},
 * 					&documentdb.SeedNodeArgs{
 * 						IpAddress: pulumi.String("10.52.221.4"),
 * 					},
 * 				},
 * 				HoursBetweenBackups:           pulumi.Int(24),
 * 				InitialCassandraAdminPassword: pulumi.String("mypassword"),
 * 			},
 * 			ResourceGroupName: pulumi.String("cassandra-prod-rg"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.CassandraCluster;
 * import com.pulumi.azurenative.documentdb.CassandraClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cassandraCluster = new CassandraCluster("cassandraCluster", CassandraClusterArgs.builder()
 *             .clusterName("cassandra-prod")
 *             .location("West US")
 *             .properties(Map.ofEntries(
 *                 Map.entry("authenticationMethod", "Cassandra"),
 *                 Map.entry("cassandraVersion", "3.11"),
 *                 Map.entry("clientCertificates", Map.of("pem", """
 * -----BEGIN CERTIFICATE-----
 * ...Base64 encoded certificate...
 * -----END CERTIFICATE-----                """)),
 *                 Map.entry("clusterNameOverride", "ClusterNameIllegalForAzureResource"),
 *                 Map.entry("delegatedManagementSubnetId", "/subscriptions/536e130b-d7d6-4ac7-98a5-de20d69588d2/resourceGroups/customer-vnet-rg/providers/Microsoft.Network/virtualNetworks/customer-vnet/subnets/management"),
 *                 Map.entry("externalGossipCertificates", Map.of("pem", """
 * -----BEGIN CERTIFICATE-----
 * ...Base64 encoded certificate...
 * -----END CERTIFICATE-----                """)),
 *                 Map.entry("externalSeedNodes",
 *                     Map.of("ipAddress", "10.52.221.2"),
 *                     Map.of("ipAddress", "10.52.221.3"),
 *                     Map.of("ipAddress", "10.52.221.4")),
 *                 Map.entry("hoursBetweenBackups", 24),
 *                 Map.entry("initialCassandraAdminPassword", "mypassword")
 *             ))
 *             .resourceGroupName("cassandra-prod-rg")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:CassandraCluster cassandra-prod /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}
 * ```
 */
public class CassandraCluster internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.CassandraCluster,
) : KotlinCustomResource(javaResource, CassandraClusterMapper) {
    /**
     * Identity for the resource.
     */
    public val identity: Output<ManagedCassandraManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedCassandraManagedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The location of the resource group to which the resource belongs.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the ARM resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of a managed Cassandra cluster.
     */
    public val properties: Output<ClusterResourceResponseProperties>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                clusterResourceResponsePropertiesToKotlin(args0)
            })
        })

    /**
     * Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of Azure resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CassandraClusterMapper : ResourceMapper<CassandraCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.CassandraCluster::class == javaResource::class

    override fun map(javaResource: Resource): CassandraCluster = CassandraCluster(
        javaResource as
            com.pulumi.azurenative.documentdb.CassandraCluster,
    )
}

/**
 * @see [CassandraCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CassandraCluster].
 */
public suspend fun cassandraCluster(
    name: String,
    block: suspend CassandraClusterResourceBuilder.() -> Unit,
): CassandraCluster {
    val builder = CassandraClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CassandraCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cassandraCluster(name: String): CassandraCluster {
    val builder = CassandraClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
