@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.GraphResourceGraphArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.inputs.CreateUpdateOptionsArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.CreateUpdateOptionsArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.GraphResourceArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.GraphResourceArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure Cosmos DB Graph resource.
 * Azure REST API version: 2023-03-15-preview. Prior API version in Azure Native 1.x: 2021-07-01-preview.
 * Other available API versions: 2023-09-15-preview.
 * ## Example Usage
 * ### CosmosDBGraphCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var graphResourceGraph = new AzureNative.DocumentDB.GraphResourceGraph("graphResourceGraph", new()
 *     {
 *         AccountName = "ddb1",
 *         GraphName = "graphName",
 *         Location = "West US",
 *         Options = null,
 *         Resource = new AzureNative.DocumentDB.Inputs.GraphResourceArgs
 *         {
 *             Id = "graphName",
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewGraphResourceGraph(ctx, "graphResourceGraph", &documentdb.GraphResourceGraphArgs{
 * 			AccountName: pulumi.String("ddb1"),
 * 			GraphName:   pulumi.String("graphName"),
 * 			Location:    pulumi.String("West US"),
 * 			Options:     nil,
 * 			Resource: &documentdb.GraphResourceArgs{
 * 				Id: pulumi.String("graphName"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.GraphResourceGraph;
 * import com.pulumi.azurenative.documentdb.GraphResourceGraphArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var graphResourceGraph = new GraphResourceGraph("graphResourceGraph", GraphResourceGraphArgs.builder()
 *             .accountName("ddb1")
 *             .graphName("graphName")
 *             .location("West US")
 *             .options()
 *             .resource(Map.of("id", "graphName"))
 *             .resourceGroupName("rg1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:GraphResourceGraph graphName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/graphs/{graphName}
 * ```
 * @property accountName Cosmos DB database account name.
 * @property graphName Cosmos DB graph resource name.
 * @property identity Identity for the resource.
 * @property location The location of the resource group to which the resource belongs.
 * @property options A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
 * @property resource The standard JSON format of a Graph resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
 */
public data class GraphResourceGraphArgs(
    public val accountName: Output<String>? = null,
    public val graphName: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val options: Output<CreateUpdateOptionsArgs>? = null,
    public val resource: Output<GraphResourceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.GraphResourceGraphArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.GraphResourceGraphArgs =
        com.pulumi.azurenative.documentdb.GraphResourceGraphArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .graphName(graphName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .options(options?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resource(resource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GraphResourceGraphArgs].
 */
@PulumiTagMarker
public class GraphResourceGraphArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var graphName: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var options: Output<CreateUpdateOptionsArgs>? = null

    private var resource: Output<GraphResourceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("exrqcucabswxfcns")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Cosmos DB graph resource name.
     */
    @JvmName("uhiajqdhxcrlttpj")
    public suspend fun graphName(`value`: Output<String>) {
        this.graphName = value
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("ogbsewsvabidniwn")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("xdtnpojrdahsxqtt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("jahgbvffvryelonx")
    public suspend fun options(`value`: Output<CreateUpdateOptionsArgs>) {
        this.options = value
    }

    /**
     * @param value The standard JSON format of a Graph resource
     */
    @JvmName("snmjqcobbvjwwigw")
    public suspend fun resource(`value`: Output<GraphResourceArgs>) {
        this.resource = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("scxvdipmbgcnembk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("wuucgbwtrklxxnmg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("lxqmstdlgsoyvxtv")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Cosmos DB graph resource name.
     */
    @JvmName("gbuqmoltvihvgbon")
    public suspend fun graphName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.graphName = mapped
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("qdujwntodamudend")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity for the resource.
     */
    @JvmName("pfsemxmdimaooisd")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("oxruvvakenogykfr")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("xjscpertfghxkfod")
    public suspend fun options(`value`: CreateUpdateOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("obikgrrmcxfebxcx")
    public suspend fun options(argument: suspend CreateUpdateOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = CreateUpdateOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param value The standard JSON format of a Graph resource
     */
    @JvmName("fkmmhaljgdnukrtt")
    public suspend fun resource(`value`: GraphResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    /**
     * @param argument The standard JSON format of a Graph resource
     */
    @JvmName("ewfkuekfiqcpjdil")
    public suspend fun resource(argument: suspend GraphResourceArgsBuilder.() -> Unit) {
        val toBeMapped = GraphResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resource = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tchapvhyhmkdsqpe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("ubfyswisevivwvrn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("dfrslyxohvvuoefh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GraphResourceGraphArgs = GraphResourceGraphArgs(
        accountName = accountName,
        graphName = graphName,
        identity = identity,
        location = location,
        options = options,
        resource = resource,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
