@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.PrivilegeResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.RoleResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.documentdb.kotlin.outputs.PrivilegeResponse.Companion.toKotlin as privilegeResponseToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.RoleResponse.Companion.toKotlin as roleResponseToKotlin

/**
 * Builder for [MongoDBResourceMongoRoleDefinition].
 */
@PulumiTagMarker
public class MongoDBResourceMongoRoleDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MongoDBResourceMongoRoleDefinitionArgs = MongoDBResourceMongoRoleDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MongoDBResourceMongoRoleDefinitionArgsBuilder.() -> Unit) {
        val builder = MongoDBResourceMongoRoleDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MongoDBResourceMongoRoleDefinition {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.MongoDBResourceMongoRoleDefinition(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MongoDBResourceMongoRoleDefinition(builtJavaResource)
    }
}

/**
 * An Azure Cosmos DB Mongo Role Definition.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-10-15-preview.
 * Other available API versions: 2023-03-01-preview, 2023-09-15, 2023-09-15-preview.
 * ## Example Usage
 * ### CosmosDBMongoDBRoleDefinitionCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mongoDBResourceMongoRoleDefinition = new AzureNative.DocumentDB.MongoDBResourceMongoRoleDefinition("mongoDBResourceMongoRoleDefinition", new()
 *     {
 *         AccountName = "myAccountName",
 *         DatabaseName = "sales",
 *         MongoRoleDefinitionId = "myMongoRoleDefinitionId",
 *         Privileges = new[]
 *         {
 *             new AzureNative.DocumentDB.Inputs.PrivilegeArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "insert",
 *                     "find",
 *                 },
 *                 Resource = new AzureNative.DocumentDB.Inputs.PrivilegeResourceArgs
 *                 {
 *                     Collection = "sales",
 *                     Db = "sales",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroupName",
 *         RoleName = "myRoleName",
 *         Roles = new[]
 *         {
 *             new AzureNative.DocumentDB.Inputs.RoleArgs
 *             {
 *                 Db = "sales",
 *                 Role = "myInheritedRole",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewMongoDBResourceMongoRoleDefinition(ctx, "mongoDBResourceMongoRoleDefinition", &documentdb.MongoDBResourceMongoRoleDefinitionArgs{
 * 			AccountName:           pulumi.String("myAccountName"),
 * 			DatabaseName:          pulumi.String("sales"),
 * 			MongoRoleDefinitionId: pulumi.String("myMongoRoleDefinitionId"),
 * 			Privileges: []documentdb.PrivilegeArgs{
 * 				{
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("insert"),
 * 						pulumi.String("find"),
 * 					},
 * 					Resource: {
 * 						Collection: pulumi.String("sales"),
 * 						Db:         pulumi.String("sales"),
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 			RoleName:          pulumi.String("myRoleName"),
 * 			Roles: []documentdb.RoleArgs{
 * 				{
 * 					Db:   pulumi.String("sales"),
 * 					Role: pulumi.String("myInheritedRole"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.MongoDBResourceMongoRoleDefinition;
 * import com.pulumi.azurenative.documentdb.MongoDBResourceMongoRoleDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mongoDBResourceMongoRoleDefinition = new MongoDBResourceMongoRoleDefinition("mongoDBResourceMongoRoleDefinition", MongoDBResourceMongoRoleDefinitionArgs.builder()
 *             .accountName("myAccountName")
 *             .databaseName("sales")
 *             .mongoRoleDefinitionId("myMongoRoleDefinitionId")
 *             .privileges(Map.ofEntries(
 *                 Map.entry("actions",
 *                     "insert",
 *                     "find"),
 *                 Map.entry("resource", Map.ofEntries(
 *                     Map.entry("collection", "sales"),
 *                     Map.entry("db", "sales")
 *                 ))
 *             ))
 *             .resourceGroupName("myResourceGroupName")
 *             .roleName("myRoleName")
 *             .roles(Map.ofEntries(
 *                 Map.entry("db", "sales"),
 *                 Map.entry("role", "myInheritedRole")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:MongoDBResourceMongoRoleDefinition myMongoDbRoleDefinitionId /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/mongodbRoleDefinitions/{mongoRoleDefinitionId}
 * ```
 */
public class MongoDBResourceMongoRoleDefinition internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.MongoDBResourceMongoRoleDefinition,
) : KotlinCustomResource(javaResource, MongoDBResourceMongoRoleDefinitionMapper) {
    /**
     * The database name for which access is being granted for this Role Definition.
     */
    public val databaseName: Output<String>?
        get() = javaResource.databaseName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the database account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A set of privileges contained by the Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Scopes higher than Database are not enforceable as privilege.
     */
    public val privileges: Output<List<PrivilegeResponse>>?
        get() = javaResource.privileges().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> privilegeResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A user-friendly name for the Role Definition. Must be unique for the database account.
     */
    public val roleName: Output<String>?
        get() = javaResource.roleName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The set of roles inherited by this Role Definition.
     */
    public val roles: Output<List<RoleResponse>>?
        get() = javaResource.roles().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> roleResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The type of Azure resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MongoDBResourceMongoRoleDefinitionMapper :
    ResourceMapper<MongoDBResourceMongoRoleDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.MongoDBResourceMongoRoleDefinition::class == javaResource::class

    override fun map(javaResource: Resource): MongoDBResourceMongoRoleDefinition =
        MongoDBResourceMongoRoleDefinition(
            javaResource as
                com.pulumi.azurenative.documentdb.MongoDBResourceMongoRoleDefinition,
        )
}

/**
 * @see [MongoDBResourceMongoRoleDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MongoDBResourceMongoRoleDefinition].
 */
public suspend fun mongoDBResourceMongoRoleDefinition(
    name: String,
    block: suspend MongoDBResourceMongoRoleDefinitionResourceBuilder.() -> Unit,
):
    MongoDBResourceMongoRoleDefinition {
    val builder = MongoDBResourceMongoRoleDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MongoDBResourceMongoRoleDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mongoDBResourceMongoRoleDefinition(name: String): MongoDBResourceMongoRoleDefinition {
    val builder = MongoDBResourceMongoRoleDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
