@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.PermissionResponse
import com.pulumi.azurenative.documentdb.kotlin.outputs.PermissionResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SqlResourceSqlRoleDefinition].
 */
@PulumiTagMarker
public class SqlResourceSqlRoleDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlResourceSqlRoleDefinitionArgs = SqlResourceSqlRoleDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlResourceSqlRoleDefinitionArgsBuilder.() -> Unit) {
        val builder = SqlResourceSqlRoleDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SqlResourceSqlRoleDefinition {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.SqlResourceSqlRoleDefinition(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlResourceSqlRoleDefinition(builtJavaResource)
    }
}

/**
 * An Azure Cosmos DB SQL Role Definition.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * Other available API versions: 2023-09-15, 2023-09-15-preview.
 * ## Example Usage
 * ### CosmosDBSqlRoleDefinitionCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlResourceSqlRoleDefinition = new AzureNative.DocumentDB.SqlResourceSqlRoleDefinition("sqlResourceSqlRoleDefinition", new()
 *     {
 *         AccountName = "myAccountName",
 *         AssignableScopes = new[]
 *         {
 *             "/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/dbs/sales",
 *             "/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/dbs/purchases",
 *         },
 *         Permissions = new[]
 *         {
 *             new AzureNative.DocumentDB.Inputs.PermissionArgs
 *             {
 *                 DataActions = new[]
 *                 {
 *                     "Microsoft.DocumentDB/databaseAccounts/sqlDatabases/containers/items/create",
 *                     "Microsoft.DocumentDB/databaseAccounts/sqlDatabases/containers/items/read",
 *                 },
 *                 NotDataActions = new() { },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroupName",
 *         RoleDefinitionId = "myRoleDefinitionId",
 *         RoleName = "myRoleName",
 *         Type = AzureNative.DocumentDB.RoleDefinitionType.CustomRole,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewSqlResourceSqlRoleDefinition(ctx, "sqlResourceSqlRoleDefinition", &documentdb.SqlResourceSqlRoleDefinitionArgs{
 * 			AccountName: pulumi.String("myAccountName"),
 * 			AssignableScopes: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/dbs/sales"),
 * 				pulumi.String("/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/dbs/purchases"),
 * 			},
 * 			Permissions: []documentdb.PermissionArgs{
 * 				{
 * 					DataActions: pulumi.StringArray{
 * 						pulumi.String("Microsoft.DocumentDB/databaseAccounts/sqlDatabases/containers/items/create"),
 * 						pulumi.String("Microsoft.DocumentDB/databaseAccounts/sqlDatabases/containers/items/read"),
 * 					},
 * 					NotDataActions: pulumi.StringArray{},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 			RoleDefinitionId:  pulumi.String("myRoleDefinitionId"),
 * 			RoleName:          pulumi.String("myRoleName"),
 * 			Type:              documentdb.RoleDefinitionTypeCustomRole,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlRoleDefinition;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlRoleDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlResourceSqlRoleDefinition = new SqlResourceSqlRoleDefinition("sqlResourceSqlRoleDefinition", SqlResourceSqlRoleDefinitionArgs.builder()
 *             .accountName("myAccountName")
 *             .assignableScopes(
 *                 "/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/dbs/sales",
 *                 "/subscriptions/mySubscriptionId/resourceGroups/myResourceGroupName/providers/Microsoft.DocumentDB/databaseAccounts/myAccountName/dbs/purchases")
 *             .permissions(Map.ofEntries(
 *                 Map.entry("dataActions",
 *                     "Microsoft.DocumentDB/databaseAccounts/sqlDatabases/containers/items/create",
 *                     "Microsoft.DocumentDB/databaseAccounts/sqlDatabases/containers/items/read"),
 *                 Map.entry("notDataActions", )
 *             ))
 *             .resourceGroupName("myResourceGroupName")
 *             .roleDefinitionId("myRoleDefinitionId")
 *             .roleName("myRoleName")
 *             .type("CustomRole")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:SqlResourceSqlRoleDefinition myRoleDefinitionId /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleDefinitions/{roleDefinitionId}
 * ```
 */
public class SqlResourceSqlRoleDefinition internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.SqlResourceSqlRoleDefinition,
) : KotlinCustomResource(javaResource, SqlResourceSqlRoleDefinitionMapper) {
    /**
     * A set of fully qualified Scopes at or below which Role Assignments may be created using this Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Must have at least one element. Scopes higher than Database account are not enforceable as assignable Scopes. Note that resources referenced in assignable Scopes need not exist.
     */
    public val assignableScopes: Output<List<String>>?
        get() = javaResource.assignableScopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The name of the database account.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The set of operations allowed through this Role Definition.
     */
    public val permissions: Output<List<PermissionResponse>>?
        get() = javaResource.permissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A user-friendly name for the Role Definition. Must be unique for the database account.
     */
    public val roleName: Output<String>?
        get() = javaResource.roleName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of Azure resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlResourceSqlRoleDefinitionMapper : ResourceMapper<SqlResourceSqlRoleDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.SqlResourceSqlRoleDefinition::class == javaResource::class

    override fun map(javaResource: Resource): SqlResourceSqlRoleDefinition =
        SqlResourceSqlRoleDefinition(
            javaResource as
                com.pulumi.azurenative.documentdb.SqlResourceSqlRoleDefinition,
        )
}

/**
 * @see [SqlResourceSqlRoleDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlResourceSqlRoleDefinition].
 */
public suspend fun sqlResourceSqlRoleDefinition(
    name: String,
    block: suspend SqlResourceSqlRoleDefinitionResourceBuilder.() -> Unit,
):
    SqlResourceSqlRoleDefinition {
    val builder = SqlResourceSqlRoleDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlResourceSqlRoleDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlResourceSqlRoleDefinition(name: String): SqlResourceSqlRoleDefinition {
    val builder = SqlResourceSqlRoleDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
