@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.SqlResourceSqlStoredProcedureArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.inputs.CreateUpdateOptionsArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.CreateUpdateOptionsArgsBuilder
import com.pulumi.azurenative.documentdb.kotlin.inputs.SqlStoredProcedureResourceArgs
import com.pulumi.azurenative.documentdb.kotlin.inputs.SqlStoredProcedureResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure Cosmos DB storedProcedure.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview.
 * ## Example Usage
 * ### CosmosDBSqlStoredProcedureCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlResourceSqlStoredProcedure = new AzureNative.DocumentDB.SqlResourceSqlStoredProcedure("sqlResourceSqlStoredProcedure", new()
 *     {
 *         AccountName = "ddb1",
 *         ContainerName = "containerName",
 *         DatabaseName = "databaseName",
 *         Options = null,
 *         Resource = new AzureNative.DocumentDB.Inputs.SqlStoredProcedureResourceArgs
 *         {
 *             Body = "body",
 *             Id = "storedProcedureName",
 *         },
 *         ResourceGroupName = "rg1",
 *         StoredProcedureName = "storedProcedureName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewSqlResourceSqlStoredProcedure(ctx, "sqlResourceSqlStoredProcedure", &documentdb.SqlResourceSqlStoredProcedureArgs{
 * 			AccountName:   pulumi.String("ddb1"),
 * 			ContainerName: pulumi.String("containerName"),
 * 			DatabaseName:  pulumi.String("databaseName"),
 * 			Options:       nil,
 * 			Resource: &documentdb.SqlStoredProcedureResourceArgs{
 * 				Body: pulumi.String("body"),
 * 				Id:   pulumi.String("storedProcedureName"),
 * 			},
 * 			ResourceGroupName:   pulumi.String("rg1"),
 * 			StoredProcedureName: pulumi.String("storedProcedureName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlStoredProcedure;
 * import com.pulumi.azurenative.documentdb.SqlResourceSqlStoredProcedureArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlResourceSqlStoredProcedure = new SqlResourceSqlStoredProcedure("sqlResourceSqlStoredProcedure", SqlResourceSqlStoredProcedureArgs.builder()
 *             .accountName("ddb1")
 *             .containerName("containerName")
 *             .databaseName("databaseName")
 *             .options()
 *             .resource(Map.ofEntries(
 *                 Map.entry("body", "body"),
 *                 Map.entry("id", "storedProcedureName")
 *             ))
 *             .resourceGroupName("rg1")
 *             .storedProcedureName("storedProcedureName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:SqlResourceSqlStoredProcedure storedProcedureName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}
 * ```
 * @property accountName Cosmos DB database account name.
 * @property containerName Cosmos DB container name.
 * @property databaseName Cosmos DB database name.
 * @property location The location of the resource group to which the resource belongs.
 * @property options A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
 * @property resource The standard JSON format of a storedProcedure
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storedProcedureName Cosmos DB storedProcedure name.
 * @property tags Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
 */
public data class SqlResourceSqlStoredProcedureArgs(
    public val accountName: Output<String>? = null,
    public val containerName: Output<String>? = null,
    public val databaseName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val options: Output<CreateUpdateOptionsArgs>? = null,
    public val resource: Output<SqlStoredProcedureResourceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val storedProcedureName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.SqlResourceSqlStoredProcedureArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.SqlResourceSqlStoredProcedureArgs =
        com.pulumi.azurenative.documentdb.SqlResourceSqlStoredProcedureArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .options(options?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resource(resource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storedProcedureName(storedProcedureName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SqlResourceSqlStoredProcedureArgs].
 */
@PulumiTagMarker
public class SqlResourceSqlStoredProcedureArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var containerName: Output<String>? = null

    private var databaseName: Output<String>? = null

    private var location: Output<String>? = null

    private var options: Output<CreateUpdateOptionsArgs>? = null

    private var resource: Output<SqlStoredProcedureResourceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var storedProcedureName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("apjujrahhhtoodea")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Cosmos DB container name.
     */
    @JvmName("dsqenyhnxpfmsdmq")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Cosmos DB database name.
     */
    @JvmName("nlmobxstnhnhsoks")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("mlhxanshjwsoumfo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("uhdxdbjygqryxqtu")
    public suspend fun options(`value`: Output<CreateUpdateOptionsArgs>) {
        this.options = value
    }

    /**
     * @param value The standard JSON format of a storedProcedure
     */
    @JvmName("cqqnghjhgtdimeca")
    public suspend fun resource(`value`: Output<SqlStoredProcedureResourceArgs>) {
        this.resource = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vauturdglvmratyb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Cosmos DB storedProcedure name.
     */
    @JvmName("injalxodgpovgilq")
    public suspend fun storedProcedureName(`value`: Output<String>) {
        this.storedProcedureName = value
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("evbmabifoigvgfvs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("iwjjulppbowvrdtf")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Cosmos DB container name.
     */
    @JvmName("uopjkopqyiulrllc")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Cosmos DB database name.
     */
    @JvmName("rjxcoxglntnmrpbl")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The location of the resource group to which the resource belongs.
     */
    @JvmName("ydofuifscywilqap")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("lrrijkjhxyuicefu")
    public suspend fun options(`value`: CreateUpdateOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument A key-value pair of options to be applied for the request. This corresponds to the headers sent with the request.
     */
    @JvmName("ntoatqcucuakcvpi")
    public suspend fun options(argument: suspend CreateUpdateOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = CreateUpdateOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param value The standard JSON format of a storedProcedure
     */
    @JvmName("bwhnhecoacdyuetm")
    public suspend fun resource(`value`: SqlStoredProcedureResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    /**
     * @param argument The standard JSON format of a storedProcedure
     */
    @JvmName("agtkfyxojxauxgdt")
    public suspend fun resource(argument: suspend SqlStoredProcedureResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SqlStoredProcedureResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resource = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rkocdamtsaqepcqr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Cosmos DB storedProcedure name.
     */
    @JvmName("jxrlupwwynobebii")
    public suspend fun storedProcedureName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storedProcedureName = mapped
    }

    /**
     * @param value Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("thfvpvacecrksjyn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    @JvmName("vivtlngtpohwmhck")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SqlResourceSqlStoredProcedureArgs = SqlResourceSqlStoredProcedureArgs(
        accountName = accountName,
        containerName = containerName,
        databaseName = databaseName,
        location = location,
        options = options,
        resource = resource,
        resourceGroupName = resourceGroupName,
        storedProcedureName = storedProcedureName,
        tags = tags,
    )
}
