@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin

import com.pulumi.azurenative.documentdb.kotlin.outputs.TableGetPropertiesResponseOptions
import com.pulumi.azurenative.documentdb.kotlin.outputs.TableGetPropertiesResponseResource
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.documentdb.kotlin.outputs.TableGetPropertiesResponseOptions.Companion.toKotlin as tableGetPropertiesResponseOptionsToKotlin
import com.pulumi.azurenative.documentdb.kotlin.outputs.TableGetPropertiesResponseResource.Companion.toKotlin as tableGetPropertiesResponseResourceToKotlin

/**
 * Builder for [TableResourceTable].
 */
@PulumiTagMarker
public class TableResourceTableResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TableResourceTableArgs = TableResourceTableArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TableResourceTableArgsBuilder.() -> Unit) {
        val builder = TableResourceTableArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TableResourceTable {
        val builtJavaResource =
            com.pulumi.azurenative.documentdb.TableResourceTable(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TableResourceTable(builtJavaResource)
    }
}

/**
 * An Azure Cosmos DB Table.
 * Azure REST API version: 2023-04-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2019-08-01, 2023-03-15-preview, 2023-09-15, 2023-09-15-preview.
 * ## Example Usage
 * ### CosmosDBTableReplace
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tableResourceTable = new AzureNative.DocumentDB.TableResourceTable("tableResourceTable", new()
 *     {
 *         AccountName = "ddb1",
 *         Location = "West US",
 *         Options = null,
 *         Resource = new AzureNative.DocumentDB.Inputs.TableResourceArgs
 *         {
 *             Id = "tableName",
 *         },
 *         ResourceGroupName = "rg1",
 *         TableName = "tableName",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/documentdb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := documentdb.NewTableResourceTable(ctx, "tableResourceTable", &documentdb.TableResourceTableArgs{
 * 			AccountName: pulumi.String("ddb1"),
 * 			Location:    pulumi.String("West US"),
 * 			Options:     nil,
 * 			Resource: &documentdb.TableResourceArgs{
 * 				Id: pulumi.String("tableName"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			TableName:         pulumi.String("tableName"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.documentdb.TableResourceTable;
 * import com.pulumi.azurenative.documentdb.TableResourceTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tableResourceTable = new TableResourceTable("tableResourceTable", TableResourceTableArgs.builder()
 *             .accountName("ddb1")
 *             .location("West US")
 *             .options()
 *             .resource(Map.of("id", "tableName"))
 *             .resourceGroupName("rg1")
 *             .tableName("tableName")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:documentdb:TableResourceTable tableName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/tables/{tableName}
 * ```
 */
public class TableResourceTable internal constructor(
    override val javaResource: com.pulumi.azurenative.documentdb.TableResourceTable,
) : KotlinCustomResource(javaResource, TableResourceTableMapper) {
    /**
     * The location of the resource group to which the resource belongs.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the ARM resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val options: Output<TableGetPropertiesResponseOptions>?
        get() = javaResource.options().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    tableGetPropertiesResponseOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    public val resource: Output<TableGetPropertiesResponseResource>?
        get() = javaResource.resource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    tableGetPropertiesResponseResourceToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Tags are a list of key-value pairs that describe the resource. These tags can be used in viewing and grouping this resource (across resource groups). A maximum of 15 tags can be provided for a resource. Each tag must have a key no greater than 128 characters and value no greater than 256 characters. For example, the default experience for a template type is set with "defaultExperience": "Cassandra". Current "defaultExperience" values also include "Table", "Graph", "DocumentDB", and "MongoDB".
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of Azure resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TableResourceTableMapper : ResourceMapper<TableResourceTable> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.documentdb.TableResourceTable::class == javaResource::class

    override fun map(javaResource: Resource): TableResourceTable = TableResourceTable(
        javaResource as
            com.pulumi.azurenative.documentdb.TableResourceTable,
    )
}

/**
 * @see [TableResourceTable].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TableResourceTable].
 */
public suspend fun tableResourceTable(
    name: String,
    block: suspend TableResourceTableResourceBuilder.() -> Unit,
): TableResourceTable {
    val builder = TableResourceTableResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TableResourceTable].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tableResourceTable(name: String): TableResourceTable {
    val builder = TableResourceTableResourceBuilder()
    builder.name(name)
    return builder.build()
}
