@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * ServiceType for the service.
 */
public enum class ServiceType(
    public val javaValue: com.pulumi.azurenative.documentdb.enums.ServiceType,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.enums.ServiceType> {
    SqlDedicatedGateway(com.pulumi.azurenative.documentdb.enums.ServiceType.SqlDedicatedGateway),
    DataTransfer(com.pulumi.azurenative.documentdb.enums.ServiceType.DataTransfer),
    GraphAPICompute(com.pulumi.azurenative.documentdb.enums.ServiceType.GraphAPICompute),
    MaterializedViewsBuilder(com.pulumi.azurenative.documentdb.enums.ServiceType.MaterializedViewsBuilder),
    ;

    override fun toJava(): com.pulumi.azurenative.documentdb.enums.ServiceType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.enums.ServiceType): ServiceType =
            ServiceType.values().first { it.javaValue == javaType }
    }
}
