@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.CapacityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The object that represents all properties related to capacity enforcement on an account.
 * @property totalThroughputLimit The total throughput limit imposed on the account. A totalThroughputLimit of 2000 imposes a strict limit of max throughput that can be provisioned on that account to be 2000. A totalThroughputLimit of -1 indicates no limits on provisioning of throughput.
 */
public data class CapacityArgs(
    public val totalThroughputLimit: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.CapacityArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.CapacityArgs =
        com.pulumi.azurenative.documentdb.inputs.CapacityArgs.builder()
            .totalThroughputLimit(totalThroughputLimit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CapacityArgs].
 */
@PulumiTagMarker
public class CapacityArgsBuilder internal constructor() {
    private var totalThroughputLimit: Output<Int>? = null

    /**
     * @param value The total throughput limit imposed on the account. A totalThroughputLimit of 2000 imposes a strict limit of max throughput that can be provisioned on that account to be 2000. A totalThroughputLimit of -1 indicates no limits on provisioning of throughput.
     */
    @JvmName("qdsjebeojmnyieca")
    public suspend fun totalThroughputLimit(`value`: Output<Int>) {
        this.totalThroughputLimit = value
    }

    /**
     * @param value The total throughput limit imposed on the account. A totalThroughputLimit of 2000 imposes a strict limit of max throughput that can be provisioned on that account to be 2000. A totalThroughputLimit of -1 indicates no limits on provisioning of throughput.
     */
    @JvmName("xdkaamjfavfsgkfn")
    public suspend fun totalThroughputLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.totalThroughputLimit = mapped
    }

    internal fun build(): CapacityArgs = CapacityArgs(
        totalThroughputLimit = totalThroughputLimit,
    )
}
