@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.CassandraTableResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Cosmos DB Cassandra table resource object
 * @property analyticalStorageTtl Analytical TTL.
 * @property defaultTtl Time to live of the Cosmos DB Cassandra table
 * @property id Name of the Cosmos DB Cassandra table
 * @property schema Schema of the Cosmos DB Cassandra table
 */
public data class CassandraTableResourceArgs(
    public val analyticalStorageTtl: Output<Int>? = null,
    public val defaultTtl: Output<Int>? = null,
    public val id: Output<String>,
    public val schema: Output<CassandraSchemaArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.CassandraTableResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.CassandraTableResourceArgs =
        com.pulumi.azurenative.documentdb.inputs.CassandraTableResourceArgs.builder()
            .analyticalStorageTtl(analyticalStorageTtl?.applyValue({ args0 -> args0 }))
            .defaultTtl(defaultTtl?.applyValue({ args0 -> args0 }))
            .id(id.applyValue({ args0 -> args0 }))
            .schema(schema?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CassandraTableResourceArgs].
 */
@PulumiTagMarker
public class CassandraTableResourceArgsBuilder internal constructor() {
    private var analyticalStorageTtl: Output<Int>? = null

    private var defaultTtl: Output<Int>? = null

    private var id: Output<String>? = null

    private var schema: Output<CassandraSchemaArgs>? = null

    /**
     * @param value Analytical TTL.
     */
    @JvmName("pavmhoedfxdqikgr")
    public suspend fun analyticalStorageTtl(`value`: Output<Int>) {
        this.analyticalStorageTtl = value
    }

    /**
     * @param value Time to live of the Cosmos DB Cassandra table
     */
    @JvmName("gjldfywshsuismjm")
    public suspend fun defaultTtl(`value`: Output<Int>) {
        this.defaultTtl = value
    }

    /**
     * @param value Name of the Cosmos DB Cassandra table
     */
    @JvmName("mhfpfflwdqgxkioi")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Schema of the Cosmos DB Cassandra table
     */
    @JvmName("hkcxqnscixxncjyv")
    public suspend fun schema(`value`: Output<CassandraSchemaArgs>) {
        this.schema = value
    }

    /**
     * @param value Analytical TTL.
     */
    @JvmName("pmyyahkdaujyeiaa")
    public suspend fun analyticalStorageTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.analyticalStorageTtl = mapped
    }

    /**
     * @param value Time to live of the Cosmos DB Cassandra table
     */
    @JvmName("gnivhfqrfhaeydan")
    public suspend fun defaultTtl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultTtl = mapped
    }

    /**
     * @param value Name of the Cosmos DB Cassandra table
     */
    @JvmName("lagrepiumddkhbmj")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Schema of the Cosmos DB Cassandra table
     */
    @JvmName("yqyoabhycfejqpuc")
    public suspend fun schema(`value`: CassandraSchemaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param argument Schema of the Cosmos DB Cassandra table
     */
    @JvmName("spjlpcbiskibfdrr")
    public suspend fun schema(argument: suspend CassandraSchemaArgsBuilder.() -> Unit) {
        val toBeMapped = CassandraSchemaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schema = mapped
    }

    internal fun build(): CassandraTableResourceArgs = CassandraTableResourceArgs(
        analyticalStorageTtl = analyticalStorageTtl,
        defaultTtl = defaultTtl,
        id = id ?: throw PulumiNullFieldException("id"),
        schema = schema,
    )
}
