@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.ExcludedPathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property path The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
 * */
 */
public data class ExcludedPathArgs(
    public val path: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.ExcludedPathArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.ExcludedPathArgs =
        com.pulumi.azurenative.documentdb.inputs.ExcludedPathArgs.builder()
            .path(path?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExcludedPathArgs].
 */
@PulumiTagMarker
public class ExcludedPathArgsBuilder internal constructor() {
    private var path: Output<String>? = null

    /**
     * @param value The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
     * */
     */
    @JvmName("jwqrrpelpluohqfm")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
     * */
     */
    @JvmName("yojkrkixjtivvjkd")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    internal fun build(): ExcludedPathArgs = ExcludedPathArgs(
        path = path,
    )
}
