@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetCassandraResourceCassandraKeyspacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Cosmos DB database account name.
 * @property keyspaceName Cosmos DB keyspace name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCassandraResourceCassandraKeyspacePlainArgs(
    public val accountName: String,
    public val keyspaceName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetCassandraResourceCassandraKeyspacePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.documentdb.inputs.GetCassandraResourceCassandraKeyspacePlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetCassandraResourceCassandraKeyspacePlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .keyspaceName(keyspaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCassandraResourceCassandraKeyspacePlainArgs].
 */
@PulumiTagMarker
public class GetCassandraResourceCassandraKeyspacePlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var keyspaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("eotcvrcpilyxnbcy")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Cosmos DB keyspace name.
     */
    @JvmName("qntapsfkxrarkryc")
    public suspend fun keyspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyspaceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ejispsmnavbxfmld")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCassandraResourceCassandraKeyspacePlainArgs =
        GetCassandraResourceCassandraKeyspacePlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            keyspaceName = keyspaceName ?: throw PulumiNullFieldException("keyspaceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
