@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetCassandraResourceCassandraViewPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Cosmos DB database account name.
 * @property keyspaceName Cosmos DB keyspace name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property viewName Cosmos DB view name.
 */
public data class GetCassandraResourceCassandraViewPlainArgs(
    public val accountName: String,
    public val keyspaceName: String,
    public val resourceGroupName: String,
    public val viewName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetCassandraResourceCassandraViewPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.documentdb.inputs.GetCassandraResourceCassandraViewPlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetCassandraResourceCassandraViewPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .keyspaceName(keyspaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .viewName(viewName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCassandraResourceCassandraViewPlainArgs].
 */
@PulumiTagMarker
public class GetCassandraResourceCassandraViewPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var keyspaceName: String? = null

    private var resourceGroupName: String? = null

    private var viewName: String? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("qgjgxsivhjsocmsh")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Cosmos DB keyspace name.
     */
    @JvmName("wqanhodivstcendf")
    public suspend fun keyspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyspaceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tobcvcmwrqbqwwxs")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Cosmos DB view name.
     */
    @JvmName("nhvbxcyggjjdgias")
    public suspend fun viewName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.viewName = mapped
    }

    internal fun build(): GetCassandraResourceCassandraViewPlainArgs =
        GetCassandraResourceCassandraViewPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            keyspaceName = keyspaceName ?: throw PulumiNullFieldException("keyspaceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            viewName = viewName ?: throw PulumiNullFieldException("viewName"),
        )
}
