@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetMongoClusterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mongoClusterName The name of the mongo cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetMongoClusterPlainArgs(
    public val mongoClusterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetMongoClusterPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.GetMongoClusterPlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetMongoClusterPlainArgs.builder()
            .mongoClusterName(mongoClusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMongoClusterPlainArgs].
 */
@PulumiTagMarker
public class GetMongoClusterPlainArgsBuilder internal constructor() {
    private var mongoClusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the mongo cluster.
     */
    @JvmName("xbjppwqwpqqpiiiv")
    public suspend fun mongoClusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mongoClusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tpctiugygoauffmc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMongoClusterPlainArgs = GetMongoClusterPlainArgs(
        mongoClusterName = mongoClusterName ?: throw PulumiNullFieldException("mongoClusterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
