@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GetTableResourceTablePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Cosmos DB database account name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tableName Cosmos DB table name.
 */
public data class GetTableResourceTablePlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
    public val tableName: String,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GetTableResourceTablePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.GetTableResourceTablePlainArgs =
        com.pulumi.azurenative.documentdb.inputs.GetTableResourceTablePlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .tableName(tableName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTableResourceTablePlainArgs].
 */
@PulumiTagMarker
public class GetTableResourceTablePlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    private var tableName: String? = null

    /**
     * @param value Cosmos DB database account name.
     */
    @JvmName("gbgkxafynitdbbyj")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gjjtojgtbfvdwlsw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Cosmos DB table name.
     */
    @JvmName("jbfxjmxkhvmudpwb")
    public suspend fun tableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tableName = mapped
    }

    internal fun build(): GetTableResourceTablePlainArgs = GetTableResourceTablePlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        tableName = tableName ?: throw PulumiNullFieldException("tableName"),
    )
}
