@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.GremlinDatabaseResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cosmos DB Gremlin database resource object
 * @property id Name of the Cosmos DB Gremlin database
 */
public data class GremlinDatabaseResourceArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.GremlinDatabaseResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.GremlinDatabaseResourceArgs =
        com.pulumi.azurenative.documentdb.inputs.GremlinDatabaseResourceArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GremlinDatabaseResourceArgs].
 */
@PulumiTagMarker
public class GremlinDatabaseResourceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Name of the Cosmos DB Gremlin database
     */
    @JvmName("evsyktibfcrgtaen")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the Cosmos DB Gremlin database
     */
    @JvmName("gfbtadlfoyhspwjs")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): GremlinDatabaseResourceArgs = GremlinDatabaseResourceArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
