@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.ListMongoClusterConnectionStringsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mongoClusterName The name of the mongo cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListMongoClusterConnectionStringsPlainArgs(
    public val mongoClusterName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.ListMongoClusterConnectionStringsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.documentdb.inputs.ListMongoClusterConnectionStringsPlainArgs =
        com.pulumi.azurenative.documentdb.inputs.ListMongoClusterConnectionStringsPlainArgs.builder()
            .mongoClusterName(mongoClusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListMongoClusterConnectionStringsPlainArgs].
 */
@PulumiTagMarker
public class ListMongoClusterConnectionStringsPlainArgsBuilder internal constructor() {
    private var mongoClusterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the mongo cluster.
     */
    @JvmName("lcxlvpxcbcqdmxsi")
    public suspend fun mongoClusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mongoClusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ueuchicqtjqkmsjk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListMongoClusterConnectionStringsPlainArgs =
        ListMongoClusterConnectionStringsPlainArgs(
            mongoClusterName = mongoClusterName ?: throw PulumiNullFieldException("mongoClusterName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
