@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.MongoClusterRestoreParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Parameters used for restore operations
 * @property pointInTimeUTC UTC point in time to restore a mongo cluster
 * @property sourceResourceId Resource ID to locate the source cluster to restore
 */
public data class MongoClusterRestoreParametersArgs(
    public val pointInTimeUTC: Output<String>? = null,
    public val sourceResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.MongoClusterRestoreParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.MongoClusterRestoreParametersArgs =
        com.pulumi.azurenative.documentdb.inputs.MongoClusterRestoreParametersArgs.builder()
            .pointInTimeUTC(pointInTimeUTC?.applyValue({ args0 -> args0 }))
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MongoClusterRestoreParametersArgs].
 */
@PulumiTagMarker
public class MongoClusterRestoreParametersArgsBuilder internal constructor() {
    private var pointInTimeUTC: Output<String>? = null

    private var sourceResourceId: Output<String>? = null

    /**
     * @param value UTC point in time to restore a mongo cluster
     */
    @JvmName("gegrkubojmghpanf")
    public suspend fun pointInTimeUTC(`value`: Output<String>) {
        this.pointInTimeUTC = value
    }

    /**
     * @param value Resource ID to locate the source cluster to restore
     */
    @JvmName("daayexrexiwmvrfj")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value UTC point in time to restore a mongo cluster
     */
    @JvmName("hmfruqydeaqbfshf")
    public suspend fun pointInTimeUTC(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pointInTimeUTC = mapped
    }

    /**
     * @param value Resource ID to locate the source cluster to restore
     */
    @JvmName("tavyrdrdqsdnhipg")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    internal fun build(): MongoClusterRestoreParametersArgs = MongoClusterRestoreParametersArgs(
        pointInTimeUTC = pointInTimeUTC,
        sourceResourceId = sourceResourceId,
    )
}
