@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.PeriodicModePropertiesArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.BackupStorageRedundancy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configuration values for periodic mode backup
 * @property backupIntervalInMinutes An integer representing the interval in minutes between two backups
 * @property backupRetentionIntervalInHours An integer representing the time (in hours) that each backup is retained
 * @property backupStorageRedundancy Enum to indicate type of backup residency
 */
public data class PeriodicModePropertiesArgs(
    public val backupIntervalInMinutes: Output<Int>? = null,
    public val backupRetentionIntervalInHours: Output<Int>? = null,
    public val backupStorageRedundancy: Output<Either<String, BackupStorageRedundancy>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.PeriodicModePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.PeriodicModePropertiesArgs =
        com.pulumi.azurenative.documentdb.inputs.PeriodicModePropertiesArgs.builder()
            .backupIntervalInMinutes(backupIntervalInMinutes?.applyValue({ args0 -> args0 }))
            .backupRetentionIntervalInHours(backupRetentionIntervalInHours?.applyValue({ args0 -> args0 }))
            .backupStorageRedundancy(
                backupStorageRedundancy?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [PeriodicModePropertiesArgs].
 */
@PulumiTagMarker
public class PeriodicModePropertiesArgsBuilder internal constructor() {
    private var backupIntervalInMinutes: Output<Int>? = null

    private var backupRetentionIntervalInHours: Output<Int>? = null

    private var backupStorageRedundancy: Output<Either<String, BackupStorageRedundancy>>? = null

    /**
     * @param value An integer representing the interval in minutes between two backups
     */
    @JvmName("xipsslsbxuyejpay")
    public suspend fun backupIntervalInMinutes(`value`: Output<Int>) {
        this.backupIntervalInMinutes = value
    }

    /**
     * @param value An integer representing the time (in hours) that each backup is retained
     */
    @JvmName("foaxttnrfxekcaif")
    public suspend fun backupRetentionIntervalInHours(`value`: Output<Int>) {
        this.backupRetentionIntervalInHours = value
    }

    /**
     * @param value Enum to indicate type of backup residency
     */
    @JvmName("lyigkhbqkxlfctra")
    public suspend
    fun backupStorageRedundancy(`value`: Output<Either<String, BackupStorageRedundancy>>) {
        this.backupStorageRedundancy = value
    }

    /**
     * @param value An integer representing the interval in minutes between two backups
     */
    @JvmName("mkxydrdvcybuhfev")
    public suspend fun backupIntervalInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupIntervalInMinutes = mapped
    }

    /**
     * @param value An integer representing the time (in hours) that each backup is retained
     */
    @JvmName("vlavhmqwpksthans")
    public suspend fun backupRetentionIntervalInHours(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupRetentionIntervalInHours = mapped
    }

    /**
     * @param value Enum to indicate type of backup residency
     */
    @JvmName("skeqkmfclxiiymru")
    public suspend fun backupStorageRedundancy(`value`: Either<String, BackupStorageRedundancy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupStorageRedundancy = mapped
    }

    /**
     * @param value Enum to indicate type of backup residency
     */
    @JvmName("clnoutenouqoxxae")
    public fun backupStorageRedundancy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackupStorageRedundancy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupStorageRedundancy = mapped
    }

    /**
     * @param value Enum to indicate type of backup residency
     */
    @JvmName("syppbxsxbblfbpno")
    public fun backupStorageRedundancy(`value`: BackupStorageRedundancy) {
        val toBeMapped = Either.ofRight<String, BackupStorageRedundancy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupStorageRedundancy = mapped
    }

    internal fun build(): PeriodicModePropertiesArgs = PeriodicModePropertiesArgs(
        backupIntervalInMinutes = backupIntervalInMinutes,
        backupRetentionIntervalInHours = backupRetentionIntervalInHours,
        backupStorageRedundancy = backupStorageRedundancy,
    )
}
