@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.SqlUserDefinedFunctionResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cosmos DB SQL userDefinedFunction resource object
 * @property body Body of the User Defined Function
 * @property id Name of the Cosmos DB SQL userDefinedFunction
 */
public data class SqlUserDefinedFunctionResourceArgs(
    public val body: Output<String>? = null,
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.SqlUserDefinedFunctionResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.SqlUserDefinedFunctionResourceArgs =
        com.pulumi.azurenative.documentdb.inputs.SqlUserDefinedFunctionResourceArgs.builder()
            .body(body?.applyValue({ args0 -> args0 }))
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlUserDefinedFunctionResourceArgs].
 */
@PulumiTagMarker
public class SqlUserDefinedFunctionResourceArgsBuilder internal constructor() {
    private var body: Output<String>? = null

    private var id: Output<String>? = null

    /**
     * @param value Body of the User Defined Function
     */
    @JvmName("epirlabuchenblut")
    public suspend fun body(`value`: Output<String>) {
        this.body = value
    }

    /**
     * @param value Name of the Cosmos DB SQL userDefinedFunction
     */
    @JvmName("wcaetfdkgepacpoa")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Body of the User Defined Function
     */
    @JvmName("cpyffvgfbstvaupe")
    public suspend fun body(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param value Name of the Cosmos DB SQL userDefinedFunction
     */
    @JvmName("iqwnpyqycfwecciw")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): SqlUserDefinedFunctionResourceArgs = SqlUserDefinedFunctionResourceArgs(
        body = body,
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
