@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An Azure Cosmos DB Mongo Role Definition.
 * @property databaseName The database name for which access is being granted for this Role Definition.
 * @property id The unique resource identifier of the database account.
 * @property name The name of the database account.
 * @property privileges A set of privileges contained by the Role Definition. This will allow application of this Role Definition on the entire database account or any underlying Database / Collection. Scopes higher than Database are not enforceable as privilege.
 * @property roleName A user-friendly name for the Role Definition. Must be unique for the database account.
 * @property roles The set of roles inherited by this Role Definition.
 * @property type The type of Azure resource.
 */
public data class GetMongoDBResourceMongoRoleDefinitionResult(
    public val databaseName: String? = null,
    public val id: String,
    public val name: String,
    public val privileges: List<PrivilegeResponse>? = null,
    public val roleName: String? = null,
    public val roles: List<RoleResponse>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.GetMongoDBResourceMongoRoleDefinitionResult):
            GetMongoDBResourceMongoRoleDefinitionResult = GetMongoDBResourceMongoRoleDefinitionResult(
            databaseName = javaType.databaseName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            privileges = javaType.privileges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.PrivilegeResponse.Companion.toKotlin(args0)
                })
            }),
            roleName = javaType.roleName().map({ args0 -> args0 }).orElse(null),
            roles = javaType.roles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.RoleResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
