@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property analyticalStorageTtl Analytical TTL.
 * @property conflictResolutionPolicy The conflict resolution policy for the graph.
 * @property defaultTtl Default time to live
 * @property etag A system generated property representing the resource etag required for optimistic concurrency control.
 * @property id Name of the Cosmos DB Gremlin graph
 * @property indexingPolicy The configuration of the indexing policy. By default, the indexing is automatic for all document paths within the graph
 * @property partitionKey The configuration of the partition key to be used for partitioning data into multiple partitions
 * @property rid A system generated property. A unique identifier.
 * @property ts A system generated property that denotes the last updated timestamp of the resource.
 * @property uniqueKeyPolicy The unique key policy configuration for specifying uniqueness constraints on documents in the collection in the Azure Cosmos DB service.
 */
public data class GremlinGraphGetPropertiesResponseResource(
    public val analyticalStorageTtl: Double? = null,
    public val conflictResolutionPolicy: ConflictResolutionPolicyResponse? = null,
    public val defaultTtl: Int? = null,
    public val etag: String,
    public val id: String,
    public val indexingPolicy: IndexingPolicyResponse? = null,
    public val partitionKey: ContainerPartitionKeyResponse? = null,
    public val rid: String,
    public val ts: Double,
    public val uniqueKeyPolicy: UniqueKeyPolicyResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.GremlinGraphGetPropertiesResponseResource):
            GremlinGraphGetPropertiesResponseResource = GremlinGraphGetPropertiesResponseResource(
            analyticalStorageTtl = javaType.analyticalStorageTtl().map({ args0 -> args0 }).orElse(null),
            conflictResolutionPolicy = javaType.conflictResolutionPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.ConflictResolutionPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defaultTtl = javaType.defaultTtl().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            indexingPolicy = javaType.indexingPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.IndexingPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            partitionKey = javaType.partitionKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.ContainerPartitionKeyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rid = javaType.rid(),
            ts = javaType.ts(),
            uniqueKeyPolicy = javaType.uniqueKeyPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.UniqueKeyPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
