@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Identity for the resource.
 * @property principalId The object id of the identity resource.
 * @property tenantId The tenant id of the resource.
 * @property type The type of the resource.
 */
public data class ManagedCassandraManagedServiceIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.ManagedCassandraManagedServiceIdentityResponse):
            ManagedCassandraManagedServiceIdentityResponse =
            ManagedCassandraManagedServiceIdentityResponse(
                principalId = javaType.principalId(),
                tenantId = javaType.tenantId(),
                type = javaType.type().map({ args0 -> args0 }).orElse(null),
            )
    }
}
