@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Configuration values for periodic mode backup
 * @property backupIntervalInMinutes An integer representing the interval in minutes between two backups
 * @property backupRetentionIntervalInHours An integer representing the time (in hours) that each backup is retained
 * @property backupStorageRedundancy Enum to indicate type of backup residency
 */
public data class PeriodicModePropertiesResponse(
    public val backupIntervalInMinutes: Int? = null,
    public val backupRetentionIntervalInHours: Int? = null,
    public val backupStorageRedundancy: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.PeriodicModePropertiesResponse):
            PeriodicModePropertiesResponse = PeriodicModePropertiesResponse(
            backupIntervalInMinutes = javaType.backupIntervalInMinutes().map({ args0 -> args0 }).orElse(null),
            backupRetentionIntervalInHours = javaType.backupRetentionIntervalInHours().map({ args0 ->
                args0
            }).orElse(null),
            backupStorageRedundancy = javaType.backupStorageRedundancy().map({ args0 -> args0 }).orElse(null),
        )
    }
}
