@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property path The path for which the indexing behavior applies to. Index paths typically start with root and end with wildcard (/path/*)
 * @property types List of path's spatial type
 * */
 */
public data class SpatialSpecResponse(
    public val path: String? = null,
    public val types: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.SpatialSpecResponse):
            SpatialSpecResponse = SpatialSpecResponse(
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            types = javaType.types().map({ args0 -> args0 }),
        )
    }
}
