@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin.inputs

import com.pulumi.azurenative.domainregistration.inputs.ListDomainRecommendationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keywords Keywords to be used for generating domain recommendations.
 * @property maxDomainRecommendations Maximum number of recommendations.
 */
public data class ListDomainRecommendationsPlainArgs(
    public val keywords: String? = null,
    public val maxDomainRecommendations: Int? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.domainregistration.inputs.ListDomainRecommendationsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.domainregistration.inputs.ListDomainRecommendationsPlainArgs =
        com.pulumi.azurenative.domainregistration.inputs.ListDomainRecommendationsPlainArgs.builder()
            .keywords(keywords?.let({ args0 -> args0 }))
            .maxDomainRecommendations(maxDomainRecommendations?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListDomainRecommendationsPlainArgs].
 */
@PulumiTagMarker
public class ListDomainRecommendationsPlainArgsBuilder internal constructor() {
    private var keywords: String? = null

    private var maxDomainRecommendations: Int? = null

    /**
     * @param value Keywords to be used for generating domain recommendations.
     */
    @JvmName("xdinornhphcmqssw")
    public suspend fun keywords(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keywords = mapped
    }

    /**
     * @param value Maximum number of recommendations.
     */
    @JvmName("anylqmxakgagsunq")
    public suspend fun maxDomainRecommendations(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.maxDomainRecommendations = mapped
    }

    internal fun build(): ListDomainRecommendationsPlainArgs = ListDomainRecommendationsPlainArgs(
        keywords = keywords,
        maxDomainRecommendations = maxDomainRecommendations,
    )
}
