@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Information about a domain.
 * @property authCode
 * @property autoRenew <code>true</code> if the domain should be automatically renewed; otherwise, <code>false</code>.
 * @property createdTime Domain creation timestamp.
 * @property dnsType Current DNS type
 * @property dnsZoneId Azure DNS Zone to use
 * @property domainNotRenewableReasons Reasons why domain is not renewable.
 * @property expirationTime Domain expiration timestamp.
 * @property id Resource Id.
 * @property kind Kind of resource.
 * @property lastRenewedTime Timestamp when the domain was renewed last time.
 * @property location Resource Location.
 * @property managedHostNames All hostnames derived from the domain and assigned to Azure resources.
 * @property name Resource Name.
 * @property nameServers Name servers.
 * @property privacy <code>true</code> if domain privacy is enabled for this domain; otherwise, <code>false</code>.
 * @property provisioningState Domain provisioning state.
 * @property readyForDnsRecordManagement <code>true</code> if Azure can assign this domain to App Service apps; otherwise, <code>false</code>. This value will be <code>true</code> if domain registration status is active and
 *  it is hosted on name servers Azure has programmatic access to.
 * @property registrationStatus Domain registration status.
 * @property tags Resource tags.
 * @property targetDnsType Target DNS type (would be used for migration)
 * @property type Resource type.
 */
public data class GetDomainResult(
    public val authCode: String? = null,
    public val autoRenew: Boolean? = null,
    public val createdTime: String,
    public val dnsType: String? = null,
    public val dnsZoneId: String? = null,
    public val domainNotRenewableReasons: List<String>,
    public val expirationTime: String,
    public val id: String,
    public val kind: String? = null,
    public val lastRenewedTime: String,
    public val location: String,
    public val managedHostNames: List<HostNameResponse>,
    public val name: String,
    public val nameServers: List<String>,
    public val privacy: Boolean? = null,
    public val provisioningState: String,
    public val readyForDnsRecordManagement: Boolean,
    public val registrationStatus: String,
    public val tags: Map<String, String>? = null,
    public val targetDnsType: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.domainregistration.outputs.GetDomainResult):
            GetDomainResult = GetDomainResult(
            authCode = javaType.authCode().map({ args0 -> args0 }).orElse(null),
            autoRenew = javaType.autoRenew().map({ args0 -> args0 }).orElse(null),
            createdTime = javaType.createdTime(),
            dnsType = javaType.dnsType().map({ args0 -> args0 }).orElse(null),
            dnsZoneId = javaType.dnsZoneId().map({ args0 -> args0 }).orElse(null),
            domainNotRenewableReasons = javaType.domainNotRenewableReasons().map({ args0 -> args0 }),
            expirationTime = javaType.expirationTime(),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            lastRenewedTime = javaType.lastRenewedTime(),
            location = javaType.location(),
            managedHostNames = javaType.managedHostNames().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.domainregistration.kotlin.outputs.HostNameResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            nameServers = javaType.nameServers().map({ args0 -> args0 }),
            privacy = javaType.privacy().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            readyForDnsRecordManagement = javaType.readyForDnsRecordManagement(),
            registrationStatus = javaType.registrationStatus(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetDnsType = javaType.targetDnsType().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
