@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin

import com.pulumi.azurenative.edgeorder.AddressByNameArgs.builder
import com.pulumi.azurenative.edgeorder.kotlin.inputs.ContactDetailsArgs
import com.pulumi.azurenative.edgeorder.kotlin.inputs.ContactDetailsArgsBuilder
import com.pulumi.azurenative.edgeorder.kotlin.inputs.ShippingAddressArgs
import com.pulumi.azurenative.edgeorder.kotlin.inputs.ShippingAddressArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Address Resource.
 * Azure REST API version: 2021-12-01. Prior API version in Azure Native 1.x: 2021-12-01.
 * ## Example Usage
 * ### CreateAddress
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var addressByName = new AzureNative.EdgeOrder.AddressByName("addressByName", new()
 *     {
 *         AddressName = "TestAddressName2",
 *         ContactDetails = new AzureNative.EdgeOrder.Inputs.ContactDetailsArgs
 *         {
 *             ContactName = "XXXX XXXX",
 *             EmailList = new[]
 *             {
 *                 "xxxx@xxxx.xxx",
 *             },
 *             Phone = "0000000000",
 *             PhoneExtension = "",
 *         },
 *         Location = "eastus",
 *         ResourceGroupName = "YourResourceGroupName",
 *         ShippingAddress = new AzureNative.EdgeOrder.Inputs.ShippingAddressArgs
 *         {
 *             AddressType = "None",
 *             City = "San Francisco",
 *             CompanyName = "Microsoft",
 *             Country = "US",
 *             PostalCode = "94107",
 *             StateOrProvince = "CA",
 *             StreetAddress1 = "16 TOWNSEND ST",
 *             StreetAddress2 = "UNIT 1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/edgeorder/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := edgeorder.NewAddressByName(ctx, "addressByName", &edgeorder.AddressByNameArgs{
 * 			AddressName: pulumi.String("TestAddressName2"),
 * 			ContactDetails: &edgeorder.ContactDetailsArgs{
 * 				ContactName: pulumi.String("XXXX XXXX"),
 * 				EmailList: pulumi.StringArray{
 * 					pulumi.String("xxxx@xxxx.xxx"),
 * 				},
 * 				Phone:          pulumi.String("0000000000"),
 * 				PhoneExtension: pulumi.String(""),
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("YourResourceGroupName"),
 * 			ShippingAddress: &edgeorder.ShippingAddressArgs{
 * 				AddressType:     pulumi.String("None"),
 * 				City:            pulumi.String("San Francisco"),
 * 				CompanyName:     pulumi.String("Microsoft"),
 * 				Country:         pulumi.String("US"),
 * 				PostalCode:      pulumi.String("94107"),
 * 				StateOrProvince: pulumi.String("CA"),
 * 				StreetAddress1:  pulumi.String("16 TOWNSEND ST"),
 * 				StreetAddress2:  pulumi.String("UNIT 1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.edgeorder.AddressByName;
 * import com.pulumi.azurenative.edgeorder.AddressByNameArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var addressByName = new AddressByName("addressByName", AddressByNameArgs.builder()
 *             .addressName("TestAddressName2")
 *             .contactDetails(Map.ofEntries(
 *                 Map.entry("contactName", "XXXX XXXX"),
 *                 Map.entry("emailList", "xxxx@xxxx.xxx"),
 *                 Map.entry("phone", "0000000000"),
 *                 Map.entry("phoneExtension", "")
 *             ))
 *             .location("eastus")
 *             .resourceGroupName("YourResourceGroupName")
 *             .shippingAddress(Map.ofEntries(
 *                 Map.entry("addressType", "None"),
 *                 Map.entry("city", "San Francisco"),
 *                 Map.entry("companyName", "Microsoft"),
 *                 Map.entry("country", "US"),
 *                 Map.entry("postalCode", "94107"),
 *                 Map.entry("stateOrProvince", "CA"),
 *                 Map.entry("streetAddress1", "16 TOWNSEND ST"),
 *                 Map.entry("streetAddress2", "UNIT 1")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:edgeorder:AddressByName TestAddressName2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/addresses/{addressName}
 * ```
 * @property addressName The name of the address Resource within the specified resource group. address names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
 * @property contactDetails Contact details for the address
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property shippingAddress Shipping details for the address
 * @property tags Resource tags.
 */
public data class AddressByNameArgs(
    public val addressName: Output<String>? = null,
    public val contactDetails: Output<ContactDetailsArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val shippingAddress: Output<ShippingAddressArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.AddressByNameArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.AddressByNameArgs =
        com.pulumi.azurenative.edgeorder.AddressByNameArgs.builder()
            .addressName(addressName?.applyValue({ args0 -> args0 }))
            .contactDetails(contactDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .shippingAddress(shippingAddress?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AddressByNameArgs].
 */
@PulumiTagMarker
public class AddressByNameArgsBuilder internal constructor() {
    private var addressName: Output<String>? = null

    private var contactDetails: Output<ContactDetailsArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var shippingAddress: Output<ShippingAddressArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the address Resource within the specified resource group. address names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
     */
    @JvmName("rwsxaahfmibyogvi")
    public suspend fun addressName(`value`: Output<String>) {
        this.addressName = value
    }

    /**
     * @param value Contact details for the address
     */
    @JvmName("noqqcininejdxmcy")
    public suspend fun contactDetails(`value`: Output<ContactDetailsArgs>) {
        this.contactDetails = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("bruuuvrrdwsxxsqc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fkiwlmdjkxtjmjog")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Shipping details for the address
     */
    @JvmName("iilqfwkonshwbivb")
    public suspend fun shippingAddress(`value`: Output<ShippingAddressArgs>) {
        this.shippingAddress = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mpiumuyqfiyaqjkk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the address Resource within the specified resource group. address names must be between 3 and 24 characters in length and use any alphanumeric and underscore only
     */
    @JvmName("tcnxdyktsgkrjouo")
    public suspend fun addressName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressName = mapped
    }

    /**
     * @param value Contact details for the address
     */
    @JvmName("nstvwcuttqsvcupg")
    public suspend fun contactDetails(`value`: ContactDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactDetails = mapped
    }

    /**
     * @param argument Contact details for the address
     */
    @JvmName("ovxwhaptthgomrqo")
    public suspend fun contactDetails(argument: suspend ContactDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ContactDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.contactDetails = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ajhliqyvdujcslhl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sxyctgdllexxlyvu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Shipping details for the address
     */
    @JvmName("ngejfxvtsmpdaylr")
    public suspend fun shippingAddress(`value`: ShippingAddressArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shippingAddress = mapped
    }

    /**
     * @param argument Shipping details for the address
     */
    @JvmName("sfhbfwvlcuvdjsnr")
    public suspend fun shippingAddress(argument: suspend ShippingAddressArgsBuilder.() -> Unit) {
        val toBeMapped = ShippingAddressArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.shippingAddress = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vjdsynaovtrtrnwj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jefsaisdvxaajvsq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AddressByNameArgs = AddressByNameArgs(
        addressName = addressName,
        contactDetails = contactDetails,
        location = location,
        resourceGroupName = resourceGroupName,
        shippingAddress = shippingAddress,
        tags = tags,
    )
}
