@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin

import com.pulumi.azurenative.edgeorder.OrderItemArgs.builder
import com.pulumi.azurenative.edgeorder.kotlin.inputs.AddressDetailsArgs
import com.pulumi.azurenative.edgeorder.kotlin.inputs.AddressDetailsArgsBuilder
import com.pulumi.azurenative.edgeorder.kotlin.inputs.OrderItemDetailsArgs
import com.pulumi.azurenative.edgeorder.kotlin.inputs.OrderItemDetailsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents order item resource.
 * Azure REST API version: 2022-05-01-preview.
 * ## Example Usage
 * ### CreateOrderItem
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var orderItem = new AzureNative.EdgeOrder.OrderItem("orderItem", new()
 *     {
 *         AddressDetails = new AzureNative.EdgeOrder.Inputs.AddressDetailsArgs
 *         {
 *             ForwardAddress = new AzureNative.EdgeOrder.Inputs.AddressPropertiesArgs
 *             {
 *                 ContactDetails = new AzureNative.EdgeOrder.Inputs.ContactDetailsArgs
 *                 {
 *                     ContactName = "XXXX XXXX",
 *                     EmailList = new[]
 *                     {
 *                         "xxxx@xxxx.xxx",
 *                     },
 *                     Phone = "0000000000",
 *                     PhoneExtension = "",
 *                 },
 *                 ShippingAddress = new AzureNative.EdgeOrder.Inputs.ShippingAddressArgs
 *                 {
 *                     AddressType = "None",
 *                     City = "San Francisco",
 *                     CompanyName = "Microsoft",
 *                     Country = "US",
 *                     PostalCode = "94107",
 *                     StateOrProvince = "CA",
 *                     StreetAddress1 = "16 TOWNSEND ST",
 *                     StreetAddress2 = "UNIT 1",
 *                 },
 *             },
 *         },
 *         Location = "eastus",
 *         OrderId = "/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName2",
 *         OrderItemDetails = new AzureNative.EdgeOrder.Inputs.OrderItemDetailsArgs
 *         {
 *             OrderItemType = "Purchase",
 *             Preferences = new AzureNative.EdgeOrder.Inputs.PreferencesArgs
 *             {
 *                 TransportPreferences = new AzureNative.EdgeOrder.Inputs.TransportPreferencesArgs
 *                 {
 *                     PreferredShipmentType = "MicrosoftManaged",
 *                 },
 *             },
 *             ProductDetails = new AzureNative.EdgeOrder.Inputs.ProductDetailsArgs
 *             {
 *                 HierarchyInformation = new AzureNative.EdgeOrder.Inputs.HierarchyInformationArgs
 *                 {
 *                     ConfigurationName = "edgep_base",
 *                     ProductFamilyName = "azurestackedge",
 *                     ProductLineName = "azurestackedge",
 *                     ProductName = "azurestackedgegpu",
 *                 },
 *             },
 *         },
 *         OrderItemName = "TestOrderItemName2",
 *         ResourceGroupName = "YourResourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/edgeorder/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := edgeorder.NewOrderItem(ctx, "orderItem", &edgeorder.OrderItemArgs{
 * AddressDetails: edgeorder.AddressDetailsResponse{
 * ForwardAddress: interface{}{
 * ContactDetails: &edgeorder.ContactDetailsArgs{
 * ContactName: pulumi.String("XXXX XXXX"),
 * EmailList: pulumi.StringArray{
 * pulumi.String("xxxx@xxxx.xxx"),
 * },
 * Phone: pulumi.String("0000000000"),
 * PhoneExtension: pulumi.String(""),
 * },
 * ShippingAddress: &edgeorder.ShippingAddressArgs{
 * AddressType: pulumi.String("None"),
 * City: pulumi.String("San Francisco"),
 * CompanyName: pulumi.String("Microsoft"),
 * Country: pulumi.String("US"),
 * PostalCode: pulumi.String("94107"),
 * StateOrProvince: pulumi.String("CA"),
 * StreetAddress1: pulumi.String("16 TOWNSEND ST"),
 * StreetAddress2: pulumi.String("UNIT 1"),
 * },
 * },
 * },
 * Location: pulumi.String("eastus"),
 * OrderId: pulumi.String("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName2"),
 * OrderItemDetails: edgeorder.OrderItemDetailsResponse{
 * OrderItemType: pulumi.String("Purchase"),
 * Preferences: interface{}{
 * TransportPreferences: &edgeorder.TransportPreferencesArgs{
 * PreferredShipmentType: pulumi.String("MicrosoftManaged"),
 * },
 * },
 * ProductDetails: interface{}{
 * HierarchyInformation: &edgeorder.HierarchyInformationArgs{
 * ConfigurationName: pulumi.String("edgep_base"),
 * ProductFamilyName: pulumi.String("azurestackedge"),
 * ProductLineName: pulumi.String("azurestackedge"),
 * ProductName: pulumi.String("azurestackedgegpu"),
 * },
 * },
 * },
 * OrderItemName: pulumi.String("TestOrderItemName2"),
 * ResourceGroupName: pulumi.String("YourResourceGroupName"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.edgeorder.OrderItem;
 * import com.pulumi.azurenative.edgeorder.OrderItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var orderItem = new OrderItem("orderItem", OrderItemArgs.builder()
 *             .addressDetails(Map.of("forwardAddress", Map.ofEntries(
 *                 Map.entry("contactDetails", Map.ofEntries(
 *                     Map.entry("contactName", "XXXX XXXX"),
 *                     Map.entry("emailList", "xxxx@xxxx.xxx"),
 *                     Map.entry("phone", "0000000000"),
 *                     Map.entry("phoneExtension", "")
 *                 )),
 *                 Map.entry("shippingAddress", Map.ofEntries(
 *                     Map.entry("addressType", "None"),
 *                     Map.entry("city", "San Francisco"),
 *                     Map.entry("companyName", "Microsoft"),
 *                     Map.entry("country", "US"),
 *                     Map.entry("postalCode", "94107"),
 *                     Map.entry("stateOrProvince", "CA"),
 *                     Map.entry("streetAddress1", "16 TOWNSEND ST"),
 *                     Map.entry("streetAddress2", "UNIT 1")
 *                 ))
 *             )))
 *             .location("eastus")
 *             .orderId("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName2")
 *             .orderItemDetails(Map.ofEntries(
 *                 Map.entry("orderItemType", "Purchase"),
 *                 Map.entry("preferences", Map.of("transportPreferences", Map.of("preferredShipmentType", "MicrosoftManaged"))),
 *                 Map.entry("productDetails", Map.of("hierarchyInformation", Map.ofEntries(
 *                     Map.entry("configurationName", "edgep_base"),
 *                     Map.entry("productFamilyName", "azurestackedge"),
 *                     Map.entry("productLineName", "azurestackedge"),
 *                     Map.entry("productName", "azurestackedgegpu")
 *                 )))
 *             ))
 *             .orderItemName("TestOrderItemName2")
 *             .resourceGroupName("YourResourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:edgeorder:OrderItem TestOrderItemName2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}
 * ```
 * @property addressDetails Represents shipping and return address for order item.
 * @property location The geo-location where the resource lives
 * @property orderId Id of the order to which order item belongs to.
 * @property orderItemDetails Represents order item details.
 * @property orderItemName The name of the order item.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class OrderItemArgs(
    public val addressDetails: Output<AddressDetailsArgs>? = null,
    public val location: Output<String>? = null,
    public val orderId: Output<String>? = null,
    public val orderItemDetails: Output<OrderItemDetailsArgs>? = null,
    public val orderItemName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.OrderItemArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.OrderItemArgs =
        com.pulumi.azurenative.edgeorder.OrderItemArgs.builder()
            .addressDetails(addressDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .orderId(orderId?.applyValue({ args0 -> args0 }))
            .orderItemDetails(orderItemDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .orderItemName(orderItemName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [OrderItemArgs].
 */
@PulumiTagMarker
public class OrderItemArgsBuilder internal constructor() {
    private var addressDetails: Output<AddressDetailsArgs>? = null

    private var location: Output<String>? = null

    private var orderId: Output<String>? = null

    private var orderItemDetails: Output<OrderItemDetailsArgs>? = null

    private var orderItemName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Represents shipping and return address for order item.
     */
    @JvmName("ptjsduoaelaniidp")
    public suspend fun addressDetails(`value`: Output<AddressDetailsArgs>) {
        this.addressDetails = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vrefdewaacftjvlx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Id of the order to which order item belongs to.
     */
    @JvmName("mbanikrnwftfahqm")
    public suspend fun orderId(`value`: Output<String>) {
        this.orderId = value
    }

    /**
     * @param value Represents order item details.
     */
    @JvmName("trqcrkrwqdxefacf")
    public suspend fun orderItemDetails(`value`: Output<OrderItemDetailsArgs>) {
        this.orderItemDetails = value
    }

    /**
     * @param value The name of the order item.
     */
    @JvmName("svpaobpgxqikhxct")
    public suspend fun orderItemName(`value`: Output<String>) {
        this.orderItemName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("owpfrsrggdiynabt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tmbuxwqflqrrosrd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Represents shipping and return address for order item.
     */
    @JvmName("cpaabyfaqhjlxwvl")
    public suspend fun addressDetails(`value`: AddressDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressDetails = mapped
    }

    /**
     * @param argument Represents shipping and return address for order item.
     */
    @JvmName("wuqsxinimambpnbb")
    public suspend fun addressDetails(argument: suspend AddressDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = AddressDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.addressDetails = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("aammclfiiapnuddb")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Id of the order to which order item belongs to.
     */
    @JvmName("dplhcdfndkwfmmpa")
    public suspend fun orderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orderId = mapped
    }

    /**
     * @param value Represents order item details.
     */
    @JvmName("uqvsbrowvykhsebf")
    public suspend fun orderItemDetails(`value`: OrderItemDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orderItemDetails = mapped
    }

    /**
     * @param argument Represents order item details.
     */
    @JvmName("rwxuaejlypypyqic")
    public suspend fun orderItemDetails(argument: suspend OrderItemDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = OrderItemDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.orderItemDetails = mapped
    }

    /**
     * @param value The name of the order item.
     */
    @JvmName("xgkvlhmaylosbcxc")
    public suspend fun orderItemName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orderItemName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("viqtwfofwkjsiqee")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mcvaxxyqdclpmbix")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("naghaeyhccbcymbx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): OrderItemArgs = OrderItemArgs(
        addressDetails = addressDetails,
        location = location,
        orderId = orderId,
        orderItemDetails = orderItemDetails,
        orderItemName = orderItemName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
