@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Double encryption status as entered by the customer. It is compulsory to give this parameter if the 'Deny' or 'Disabled' policy is configured.
 */
public enum class DoubleEncryptionStatus(
    public val javaValue: com.pulumi.azurenative.edgeorder.enums.DoubleEncryptionStatus,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.enums.DoubleEncryptionStatus> {
    /**
     * Double encryption is disabled
     */
    Disabled(com.pulumi.azurenative.edgeorder.enums.DoubleEncryptionStatus.Disabled),

    /**
     * Double encryption is enabled
     */
    Enabled(com.pulumi.azurenative.edgeorder.enums.DoubleEncryptionStatus.Enabled),
    ;

    override fun toJava(): com.pulumi.azurenative.edgeorder.enums.DoubleEncryptionStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.enums.DoubleEncryptionStatus):
            DoubleEncryptionStatus = DoubleEncryptionStatus.values().first { it.javaValue == javaType }
    }
}
