@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Defines the mode of the Order item.
 */
public enum class OrderMode(
    public val javaValue: com.pulumi.azurenative.edgeorder.enums.OrderMode,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.enums.OrderMode> {
    /**
     * Default Order mode.
     */
    Default(com.pulumi.azurenative.edgeorder.enums.OrderMode.Default),

    /**
     * Mode in which the Order will not be fulfilled.
     */
    DoNotFulfill(com.pulumi.azurenative.edgeorder.enums.OrderMode.DoNotFulfill),
    ;

    override fun toJava(): com.pulumi.azurenative.edgeorder.enums.OrderMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.enums.OrderMode): OrderMode =
            OrderMode.values().first { it.javaValue == javaType }
    }
}
