@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.ConfigurationFilters.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Configuration filters
 * @property filterableProperty Filters specific to product
 * @property hierarchyInformation Product hierarchy information
 */
public data class ConfigurationFilters(
    public val filterableProperty: List<FilterableProperty>? = null,
    public val hierarchyInformation: HierarchyInformation,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.ConfigurationFilters> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.ConfigurationFilters =
        com.pulumi.azurenative.edgeorder.inputs.ConfigurationFilters.builder()
            .filterableProperty(
                filterableProperty?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .hierarchyInformation(
                hierarchyInformation.let({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConfigurationFilters].
 */
@PulumiTagMarker
public class ConfigurationFiltersBuilder internal constructor() {
    private var filterableProperty: List<FilterableProperty>? = null

    private var hierarchyInformation: HierarchyInformation? = null

    /**
     * @param value Filters specific to product
     */
    @JvmName("stxdinobdbrxqalg")
    public suspend fun filterableProperty(`value`: List<FilterableProperty>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filterableProperty = mapped
    }

    /**
     * @param argument Filters specific to product
     */
    @JvmName("mrrhailrfdvwlvhp")
    public suspend
    fun filterableProperty(argument: List<suspend FilterablePropertyBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FilterablePropertyBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filterableProperty = mapped
    }

    /**
     * @param argument Filters specific to product
     */
    @JvmName("lpoelhivmeicfjgq")
    public suspend fun filterableProperty(
        vararg
        argument: suspend FilterablePropertyBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FilterablePropertyBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filterableProperty = mapped
    }

    /**
     * @param argument Filters specific to product
     */
    @JvmName("pwowbmqlflbeewwd")
    public suspend fun filterableProperty(argument: suspend FilterablePropertyBuilder.() -> Unit) {
        val toBeMapped = listOf(FilterablePropertyBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filterableProperty = mapped
    }

    /**
     * @param values Filters specific to product
     */
    @JvmName("cjeixwxggjcnsyop")
    public suspend fun filterableProperty(vararg values: FilterableProperty) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filterableProperty = mapped
    }

    /**
     * @param value Product hierarchy information
     */
    @JvmName("kqfsqialrrrexmik")
    public suspend fun hierarchyInformation(`value`: HierarchyInformation) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hierarchyInformation = mapped
    }

    /**
     * @param argument Product hierarchy information
     */
    @JvmName("rcprrevcogrpeynx")
    public suspend
    fun hierarchyInformation(argument: suspend HierarchyInformationBuilder.() -> Unit) {
        val toBeMapped = HierarchyInformationBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.hierarchyInformation = mapped
    }

    internal fun build(): ConfigurationFilters = ConfigurationFilters(
        filterableProperty = filterableProperty,
        hierarchyInformation = hierarchyInformation ?: throw
            PulumiNullFieldException("hierarchyInformation"),
    )
}
