@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.ContactDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Contact Details.
 * @property contactName Contact name of the person.
 * @property emailList List of Email-ids to be notified about job progress.
 * @property mobile Mobile number of the contact person.
 * @property phone Phone number of the contact person.
 * @property phoneExtension Phone extension number of the contact person.
 */
public data class ContactDetailsArgs(
    public val contactName: Output<String>,
    public val emailList: Output<List<String>>,
    public val mobile: Output<String>? = null,
    public val phone: Output<String>,
    public val phoneExtension: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.ContactDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.ContactDetailsArgs =
        com.pulumi.azurenative.edgeorder.inputs.ContactDetailsArgs.builder()
            .contactName(contactName.applyValue({ args0 -> args0 }))
            .emailList(emailList.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .mobile(mobile?.applyValue({ args0 -> args0 }))
            .phone(phone.applyValue({ args0 -> args0 }))
            .phoneExtension(phoneExtension?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContactDetailsArgs].
 */
@PulumiTagMarker
public class ContactDetailsArgsBuilder internal constructor() {
    private var contactName: Output<String>? = null

    private var emailList: Output<List<String>>? = null

    private var mobile: Output<String>? = null

    private var phone: Output<String>? = null

    private var phoneExtension: Output<String>? = null

    /**
     * @param value Contact name of the person.
     */
    @JvmName("pjvfricrkashdvta")
    public suspend fun contactName(`value`: Output<String>) {
        this.contactName = value
    }

    /**
     * @param value List of Email-ids to be notified about job progress.
     */
    @JvmName("udjupspjyybisulw")
    public suspend fun emailList(`value`: Output<List<String>>) {
        this.emailList = value
    }

    @JvmName("fhurivwjpxenukjj")
    public suspend fun emailList(vararg values: Output<String>) {
        this.emailList = Output.all(values.asList())
    }

    /**
     * @param values List of Email-ids to be notified about job progress.
     */
    @JvmName("ikcjkkwwequjotnm")
    public suspend fun emailList(values: List<Output<String>>) {
        this.emailList = Output.all(values)
    }

    /**
     * @param value Mobile number of the contact person.
     */
    @JvmName("ngusqlmlprpdhgks")
    public suspend fun mobile(`value`: Output<String>) {
        this.mobile = value
    }

    /**
     * @param value Phone number of the contact person.
     */
    @JvmName("fshlfyilsmsvwxda")
    public suspend fun phone(`value`: Output<String>) {
        this.phone = value
    }

    /**
     * @param value Phone extension number of the contact person.
     */
    @JvmName("knvubdrhsprphhhl")
    public suspend fun phoneExtension(`value`: Output<String>) {
        this.phoneExtension = value
    }

    /**
     * @param value Contact name of the person.
     */
    @JvmName("hvmxujpucwuvkkey")
    public suspend fun contactName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.contactName = mapped
    }

    /**
     * @param value List of Email-ids to be notified about job progress.
     */
    @JvmName("vdvknuwpeerfobse")
    public suspend fun emailList(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailList = mapped
    }

    /**
     * @param values List of Email-ids to be notified about job progress.
     */
    @JvmName("ueaqifdtwbahkriu")
    public suspend fun emailList(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailList = mapped
    }

    /**
     * @param value Mobile number of the contact person.
     */
    @JvmName("hrlfdwdtjyuabhvm")
    public suspend fun mobile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mobile = mapped
    }

    /**
     * @param value Phone number of the contact person.
     */
    @JvmName("frtvnwxfhnwcpmya")
    public suspend fun phone(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.phone = mapped
    }

    /**
     * @param value Phone extension number of the contact person.
     */
    @JvmName("wktwkftbogweuopj")
    public suspend fun phoneExtension(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneExtension = mapped
    }

    internal fun build(): ContactDetailsArgs = ContactDetailsArgs(
        contactName = contactName ?: throw PulumiNullFieldException("contactName"),
        emailList = emailList ?: throw PulumiNullFieldException("emailList"),
        mobile = mobile,
        phone = phone ?: throw PulumiNullFieldException("phone"),
        phoneExtension = phoneExtension,
    )
}
