@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.HierarchyInformation.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Holds details about product hierarchy information.
 * @property configurationName Represents configuration name that uniquely identifies configuration.
 * @property productFamilyName Represents product family name that uniquely identifies product family.
 * @property productLineName Represents product line name that uniquely identifies product line.
 * @property productName Represents product name that uniquely identifies product.
 */
public data class HierarchyInformation(
    public val configurationName: String? = null,
    public val productFamilyName: String? = null,
    public val productLineName: String? = null,
    public val productName: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.HierarchyInformation> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.HierarchyInformation =
        com.pulumi.azurenative.edgeorder.inputs.HierarchyInformation.builder()
            .configurationName(configurationName?.let({ args0 -> args0 }))
            .productFamilyName(productFamilyName?.let({ args0 -> args0 }))
            .productLineName(productLineName?.let({ args0 -> args0 }))
            .productName(productName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [HierarchyInformation].
 */
@PulumiTagMarker
public class HierarchyInformationBuilder internal constructor() {
    private var configurationName: String? = null

    private var productFamilyName: String? = null

    private var productLineName: String? = null

    private var productName: String? = null

    /**
     * @param value Represents configuration name that uniquely identifies configuration.
     */
    @JvmName("qkwskemdrylwylem")
    public suspend fun configurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.configurationName = mapped
    }

    /**
     * @param value Represents product family name that uniquely identifies product family.
     */
    @JvmName("erqkreqjopirmhph")
    public suspend fun productFamilyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.productFamilyName = mapped
    }

    /**
     * @param value Represents product line name that uniquely identifies product line.
     */
    @JvmName("ygutfyvcwqoberwr")
    public suspend fun productLineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.productLineName = mapped
    }

    /**
     * @param value Represents product name that uniquely identifies product.
     */
    @JvmName("ktfanqaybfhshnxi")
    public suspend fun productName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.productName = mapped
    }

    internal fun build(): HierarchyInformation = HierarchyInformation(
        configurationName = configurationName,
        productFamilyName = productFamilyName,
        productLineName = productLineName,
        productName = productName,
    )
}
