@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.HierarchyInformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Holds details about product hierarchy information.
 * @property configurationName Represents configuration name that uniquely identifies configuration.
 * @property productFamilyName Represents product family name that uniquely identifies product family.
 * @property productLineName Represents product line name that uniquely identifies product line.
 * @property productName Represents product name that uniquely identifies product.
 */
public data class HierarchyInformationArgs(
    public val configurationName: Output<String>? = null,
    public val productFamilyName: Output<String>? = null,
    public val productLineName: Output<String>? = null,
    public val productName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.HierarchyInformationArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.HierarchyInformationArgs =
        com.pulumi.azurenative.edgeorder.inputs.HierarchyInformationArgs.builder()
            .configurationName(configurationName?.applyValue({ args0 -> args0 }))
            .productFamilyName(productFamilyName?.applyValue({ args0 -> args0 }))
            .productLineName(productLineName?.applyValue({ args0 -> args0 }))
            .productName(productName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HierarchyInformationArgs].
 */
@PulumiTagMarker
public class HierarchyInformationArgsBuilder internal constructor() {
    private var configurationName: Output<String>? = null

    private var productFamilyName: Output<String>? = null

    private var productLineName: Output<String>? = null

    private var productName: Output<String>? = null

    /**
     * @param value Represents configuration name that uniquely identifies configuration.
     */
    @JvmName("yighrclphfivdsux")
    public suspend fun configurationName(`value`: Output<String>) {
        this.configurationName = value
    }

    /**
     * @param value Represents product family name that uniquely identifies product family.
     */
    @JvmName("eaoatgmbdmbdcvsn")
    public suspend fun productFamilyName(`value`: Output<String>) {
        this.productFamilyName = value
    }

    /**
     * @param value Represents product line name that uniquely identifies product line.
     */
    @JvmName("ptofreeyipujkeui")
    public suspend fun productLineName(`value`: Output<String>) {
        this.productLineName = value
    }

    /**
     * @param value Represents product name that uniquely identifies product.
     */
    @JvmName("uybjinkocmaenmki")
    public suspend fun productName(`value`: Output<String>) {
        this.productName = value
    }

    /**
     * @param value Represents configuration name that uniquely identifies configuration.
     */
    @JvmName("vfbljndhmqnewjep")
    public suspend fun configurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationName = mapped
    }

    /**
     * @param value Represents product family name that uniquely identifies product family.
     */
    @JvmName("xxvlpgbpxdiegxfc")
    public suspend fun productFamilyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productFamilyName = mapped
    }

    /**
     * @param value Represents product line name that uniquely identifies product line.
     */
    @JvmName("iaypjxwunfnewpux")
    public suspend fun productLineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productLineName = mapped
    }

    /**
     * @param value Represents product name that uniquely identifies product.
     */
    @JvmName("dygvcfjladyspyya")
    public suspend fun productName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productName = mapped
    }

    internal fun build(): HierarchyInformationArgs = HierarchyInformationArgs(
        configurationName = configurationName,
        productFamilyName = productFamilyName,
        productLineName = productLineName,
        productName = productName,
    )
}
