@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Address Resource.
 * @property addressValidationStatus Status of address validation.
 * @property contactDetails Contact details for the address.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property shippingAddress Shipping details for the address.
 * @property systemData Represents resource creation and update time.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAddressResult(
    public val addressValidationStatus: String,
    public val contactDetails: ContactDetailsResponse,
    public val id: String,
    public val location: String,
    public val name: String,
    public val shippingAddress: ShippingAddressResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.GetAddressResult):
            GetAddressResult = GetAddressResult(
            addressValidationStatus = javaType.addressValidationStatus(),
            contactDetails = javaType.contactDetails().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.ContactDetailsResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            shippingAddress = javaType.shippingAddress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.ShippingAddressResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
