@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Returns link related to the product.
 * @property linkType Type of link.
 * @property linkUrl Url of the link.
 */
public data class LinkResponse(
    public val linkType: String,
    public val linkUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.LinkResponse):
            LinkResponse = LinkResponse(
            linkType = javaType.linkType(),
            linkUrl = javaType.linkUrl(),
        )
    }
}
