@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Preferences related to the order
 * @property encryptionPreferences Preferences related to the Encryption.
 * @property managementResourcePreferences Preferences related to the Management resource.
 * @property notificationPreferences Notification preferences.
 * @property transportPreferences Preferences related to the shipment logistics of the order.
 */
public data class PreferencesResponse(
    public val encryptionPreferences: EncryptionPreferencesResponse? = null,
    public val managementResourcePreferences: ManagementResourcePreferencesResponse? = null,
    public val notificationPreferences: List<NotificationPreferenceResponse>? = null,
    public val transportPreferences: TransportPreferencesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.PreferencesResponse):
            PreferencesResponse = PreferencesResponse(
            encryptionPreferences = javaType.encryptionPreferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.EncryptionPreferencesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            managementResourcePreferences = javaType.managementResourcePreferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.ManagementResourcePreferencesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            notificationPreferences = javaType.notificationPreferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.NotificationPreferenceResponse.Companion.toKotlin(args0)
                })
            }),
            transportPreferences = javaType.transportPreferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.TransportPreferencesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
