@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Product line.
 * @property availabilityInformation Availability information of the product system.
 * @property costInformation Cost information for the product system.
 * @property description Description related to the product system.
 * @property displayName Display Name for the product system.
 * @property filterableProperties List of filters supported for a product.
 * @property fulfilledBy The entity responsible for fulfillment of the item at the given hierarchy level.
 * @property hierarchyInformation Hierarchy information of a product.
 * @property imageInformation Image information for the product system.
 * @property products List of products in the product line.
 */
public data class ProductLineResponse(
    public val availabilityInformation: AvailabilityInformationResponse,
    public val costInformation: CostInformationResponse,
    public val description: DescriptionResponse,
    public val displayName: String,
    public val filterableProperties: List<FilterablePropertyResponse>,
    public val fulfilledBy: String,
    public val hierarchyInformation: HierarchyInformationResponse,
    public val imageInformation: List<ImageInformationResponse>,
    public val products: List<ProductResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.ProductLineResponse):
            ProductLineResponse = ProductLineResponse(
            availabilityInformation = javaType.availabilityInformation().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.AvailabilityInformationResponse.Companion.toKotlin(args0)
            }),
            costInformation = javaType.costInformation().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.CostInformationResponse.Companion.toKotlin(args0)
            }),
            description = javaType.description().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.DescriptionResponse.Companion.toKotlin(args0)
            }),
            displayName = javaType.displayName(),
            filterableProperties = javaType.filterableProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.FilterablePropertyResponse.Companion.toKotlin(args0)
                })
            }),
            fulfilledBy = javaType.fulfilledBy(),
            hierarchyInformation = javaType.hierarchyInformation().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.HierarchyInformationResponse.Companion.toKotlin(args0)
            }),
            imageInformation = javaType.imageInformation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.ImageInformationResponse.Companion.toKotlin(args0)
                })
            }),
            products = javaType.products().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.ProductResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
