@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.education.kotlin

import com.pulumi.azurenative.education.EducationFunctions.getLabPlain
import com.pulumi.azurenative.education.EducationFunctions.getStudentPlain
import com.pulumi.azurenative.education.kotlin.inputs.GetLabPlainArgs
import com.pulumi.azurenative.education.kotlin.inputs.GetLabPlainArgsBuilder
import com.pulumi.azurenative.education.kotlin.inputs.GetStudentPlainArgs
import com.pulumi.azurenative.education.kotlin.inputs.GetStudentPlainArgsBuilder
import com.pulumi.azurenative.education.kotlin.outputs.GetLabResult
import com.pulumi.azurenative.education.kotlin.outputs.GetStudentResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.education.kotlin.outputs.GetLabResult.Companion.toKotlin as getLabResultToKotlin
import com.pulumi.azurenative.education.kotlin.outputs.GetStudentResult.Companion.toKotlin as getStudentResultToKotlin

public object EducationFunctions {
    /**
     * Get the details for a specific lab associated with the provided billing account name, billing profile name, and invoice section name.
     * Azure REST API version: 2021-12-01-preview.
     * @param argument null
     * @return Lab details.
     */
    public suspend fun getLab(argument: GetLabPlainArgs): GetLabResult =
        getLabResultToKotlin(getLabPlain(argument.toJava()).await())

    /**
     * @see [getLab].
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @param includeBudget May be used to include budget information.
     * @param invoiceSectionName The ID that uniquely identifies an invoice section.
     * @return Lab details.
     */
    public suspend fun getLab(
        billingAccountName: String,
        billingProfileName: String,
        includeBudget: Boolean? = null,
        invoiceSectionName: String,
    ): GetLabResult {
        val argument = GetLabPlainArgs(
            billingAccountName = billingAccountName,
            billingProfileName = billingProfileName,
            includeBudget = includeBudget,
            invoiceSectionName = invoiceSectionName,
        )
        return getLabResultToKotlin(getLabPlain(argument.toJava()).await())
    }

    /**
     * @see [getLab].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;education&#46;kotlin&#46;inputs&#46;GetLabPlainArgs].
     * @return Lab details.
     */
    public suspend fun getLab(argument: suspend GetLabPlainArgsBuilder.() -> Unit): GetLabResult {
        val builder = GetLabPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLabResultToKotlin(getLabPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the details for a specific student in the specified lab by student alias
     * Azure REST API version: 2021-12-01-preview.
     * @param argument null
     * @return Student details.
     */
    public suspend fun getStudent(argument: GetStudentPlainArgs): GetStudentResult =
        getStudentResultToKotlin(getStudentPlain(argument.toJava()).await())

    /**
     * @see [getStudent].
     * @param billingAccountName The ID that uniquely identifies a billing account.
     * @param billingProfileName The ID that uniquely identifies a billing profile.
     * @param invoiceSectionName The ID that uniquely identifies an invoice section.
     * @param studentAlias Student alias.
     * @return Student details.
     */
    public suspend fun getStudent(
        billingAccountName: String,
        billingProfileName: String,
        invoiceSectionName: String,
        studentAlias: String,
    ): GetStudentResult {
        val argument = GetStudentPlainArgs(
            billingAccountName = billingAccountName,
            billingProfileName = billingProfileName,
            invoiceSectionName = invoiceSectionName,
            studentAlias = studentAlias,
        )
        return getStudentResultToKotlin(getStudentPlain(argument.toJava()).await())
    }

    /**
     * @see [getStudent].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;education&#46;kotlin&#46;inputs&#46;GetStudentPlainArgs].
     * @return Student details.
     */
    public suspend fun getStudent(argument: suspend GetStudentPlainArgsBuilder.() -> Unit):
        GetStudentResult {
        val builder = GetStudentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStudentResultToKotlin(getStudentPlain(builtArgument.toJava()).await())
    }
}
