@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.education.kotlin

import com.pulumi.azurenative.education.LabArgs.builder
import com.pulumi.azurenative.education.kotlin.inputs.AmountArgs
import com.pulumi.azurenative.education.kotlin.inputs.AmountArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Lab details.
 * Azure REST API version: 2021-12-01-preview. Prior API version in Azure Native 1.x: 2021-12-01-preview.
 * ## Example Usage
 * ### CreateLab
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var lab = new AzureNative.Education.Lab("lab", new()
 *     {
 *         BillingAccountName = "{billingAccountName}",
 *         BillingProfileName = "{billingProfileName}",
 *         BudgetPerStudent = new AzureNative.Education.Inputs.AmountArgs
 *         {
 *             Currency = "USD",
 *             Value = 100,
 *         },
 *         Description = "example lab description",
 *         DisplayName = "example lab",
 *         ExpirationDate = "2021-12-09T22:11:29.422Z",
 *         InvoiceSectionName = "{invoiceSectionName}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/education/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := education.NewLab(ctx, "lab", &education.LabArgs{
 * 			BillingAccountName: pulumi.String("{billingAccountName}"),
 * 			BillingProfileName: pulumi.String("{billingProfileName}"),
 * 			BudgetPerStudent: &education.AmountArgs{
 * 				Currency: pulumi.String("USD"),
 * 				Value:    pulumi.Float64(100),
 * 			},
 * 			Description:        pulumi.String("example lab description"),
 * 			DisplayName:        pulumi.String("example lab"),
 * 			ExpirationDate:     pulumi.String("2021-12-09T22:11:29.422Z"),
 * 			InvoiceSectionName: pulumi.String("{invoiceSectionName}"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.education.Lab;
 * import com.pulumi.azurenative.education.LabArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var lab = new Lab("lab", LabArgs.builder()
 *             .billingAccountName("{billingAccountName}")
 *             .billingProfileName("{billingProfileName}")
 *             .budgetPerStudent(Map.ofEntries(
 *                 Map.entry("currency", "USD"),
 *                 Map.entry("value", 100)
 *             ))
 *             .description("example lab description")
 *             .displayName("example lab")
 *             .expirationDate("2021-12-09T22:11:29.422Z")
 *             .invoiceSectionName("{invoiceSectionName}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:education:Lab default /providers/Microsoft.Billing/billingAccounts/{billingAccountName}/billingProfiles/{billingProfileName}/invoiceSections/{invoiceSectionName}/providers/Microsoft.Education/labs/default
 * ```
 * @property billingAccountName The ID that uniquely identifies a billing account.
 * @property billingProfileName The ID that uniquely identifies a billing profile.
 * @property budgetPerStudent Default monetary cap for each student in this lab
 * @property currency The type of currency being used for the value.
 * @property description Detail description of this lab
 * @property displayName Lab Display Name
 * @property expirationDate Default expiration date for each student in this lab
 * @property invoiceSectionName The ID that uniquely identifies an invoice section.
 * @property value Amount value.
 */
public data class LabArgs(
    public val billingAccountName: Output<String>? = null,
    public val billingProfileName: Output<String>? = null,
    public val budgetPerStudent: Output<AmountArgs>? = null,
    public val currency: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val expirationDate: Output<String>? = null,
    public val invoiceSectionName: Output<String>? = null,
    public val `value`: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.education.LabArgs> {
    override fun toJava(): com.pulumi.azurenative.education.LabArgs =
        com.pulumi.azurenative.education.LabArgs.builder()
            .billingAccountName(billingAccountName?.applyValue({ args0 -> args0 }))
            .billingProfileName(billingProfileName?.applyValue({ args0 -> args0 }))
            .budgetPerStudent(budgetPerStudent?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .currency(currency?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .expirationDate(expirationDate?.applyValue({ args0 -> args0 }))
            .invoiceSectionName(invoiceSectionName?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LabArgs].
 */
@PulumiTagMarker
public class LabArgsBuilder internal constructor() {
    private var billingAccountName: Output<String>? = null

    private var billingProfileName: Output<String>? = null

    private var budgetPerStudent: Output<AmountArgs>? = null

    private var currency: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var expirationDate: Output<String>? = null

    private var invoiceSectionName: Output<String>? = null

    private var `value`: Output<Double>? = null

    /**
     * @param value The ID that uniquely identifies a billing account.
     */
    @JvmName("fqthoejgtvgeccnw")
    public suspend fun billingAccountName(`value`: Output<String>) {
        this.billingAccountName = value
    }

    /**
     * @param value The ID that uniquely identifies a billing profile.
     */
    @JvmName("ueeypmihabguoqqh")
    public suspend fun billingProfileName(`value`: Output<String>) {
        this.billingProfileName = value
    }

    /**
     * @param value Default monetary cap for each student in this lab
     */
    @JvmName("jetojnnvryiqvgnw")
    public suspend fun budgetPerStudent(`value`: Output<AmountArgs>) {
        this.budgetPerStudent = value
    }

    /**
     * @param value The type of currency being used for the value.
     */
    @JvmName("gsecjawlcuhogjle")
    public suspend fun currency(`value`: Output<String>) {
        this.currency = value
    }

    /**
     * @param value Detail description of this lab
     */
    @JvmName("krvsqouidhotyojo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Lab Display Name
     */
    @JvmName("mwwdwotxhakkljvi")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Default expiration date for each student in this lab
     */
    @JvmName("oyvdlvhnjrmrbama")
    public suspend fun expirationDate(`value`: Output<String>) {
        this.expirationDate = value
    }

    /**
     * @param value The ID that uniquely identifies an invoice section.
     */
    @JvmName("icsrfdfhbsviddql")
    public suspend fun invoiceSectionName(`value`: Output<String>) {
        this.invoiceSectionName = value
    }

    /**
     * @param value Amount value.
     */
    @JvmName("ftbjxbheerkpwxjo")
    public suspend fun `value`(`value`: Output<Double>) {
        this.`value` = value
    }

    /**
     * @param value The ID that uniquely identifies a billing account.
     */
    @JvmName("ywjixcfitgoxoren")
    public suspend fun billingAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingAccountName = mapped
    }

    /**
     * @param value The ID that uniquely identifies a billing profile.
     */
    @JvmName("gxohgctdctwmvfvc")
    public suspend fun billingProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.billingProfileName = mapped
    }

    /**
     * @param value Default monetary cap for each student in this lab
     */
    @JvmName("aqgdmammtljneuip")
    public suspend fun budgetPerStudent(`value`: AmountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.budgetPerStudent = mapped
    }

    /**
     * @param argument Default monetary cap for each student in this lab
     */
    @JvmName("hgpbrjkgikjdtixp")
    public suspend fun budgetPerStudent(argument: suspend AmountArgsBuilder.() -> Unit) {
        val toBeMapped = AmountArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.budgetPerStudent = mapped
    }

    /**
     * @param value The type of currency being used for the value.
     */
    @JvmName("ykiajakesfqeajcb")
    public suspend fun currency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Detail description of this lab
     */
    @JvmName("qdlsdxsmxanwuwlq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Lab Display Name
     */
    @JvmName("gdjtikxjhaalkmfb")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Default expiration date for each student in this lab
     */
    @JvmName("hehwumqxfqqiyqhy")
    public suspend fun expirationDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationDate = mapped
    }

    /**
     * @param value The ID that uniquely identifies an invoice section.
     */
    @JvmName("ydepfthqlikqjpou")
    public suspend fun invoiceSectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invoiceSectionName = mapped
    }

    /**
     * @param value Amount value.
     */
    @JvmName("xunlbfhkfvuxokve")
    public suspend fun `value`(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): LabArgs = LabArgs(
        billingAccountName = billingAccountName,
        billingProfileName = billingProfileName,
        budgetPerStudent = budgetPerStudent,
        currency = currency,
        description = description,
        displayName = displayName,
        expirationDate = expirationDate,
        invoiceSectionName = invoiceSectionName,
        `value` = `value`,
    )
}
