@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.education.kotlin.inputs

import com.pulumi.azurenative.education.inputs.AmountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The amount.
 * @property currency The type of currency being used for the value.
 * @property value Amount value.
 */
public data class AmountArgs(
    public val currency: Output<String>? = null,
    public val `value`: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.education.inputs.AmountArgs> {
    override fun toJava(): com.pulumi.azurenative.education.inputs.AmountArgs =
        com.pulumi.azurenative.education.inputs.AmountArgs.builder()
            .currency(currency?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmountArgs].
 */
@PulumiTagMarker
public class AmountArgsBuilder internal constructor() {
    private var currency: Output<String>? = null

    private var `value`: Output<Double>? = null

    /**
     * @param value The type of currency being used for the value.
     */
    @JvmName("pkemrnbkadwpnnlo")
    public suspend fun currency(`value`: Output<String>) {
        this.currency = value
    }

    /**
     * @param value Amount value.
     */
    @JvmName("iykpudvpeqvikwyj")
    public suspend fun `value`(`value`: Output<Double>) {
        this.`value` = value
    }

    /**
     * @param value The type of currency being used for the value.
     */
    @JvmName("njvdxrqrofrhaoma")
    public suspend fun currency(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.currency = mapped
    }

    /**
     * @param value Amount value.
     */
    @JvmName("macisaokcgnenhan")
    public suspend fun `value`(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): AmountArgs = AmountArgs(
        currency = currency,
        `value` = `value`,
    )
}
