@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin

import com.pulumi.azurenative.elastic.kotlin.outputs.MonitoringTagRulesPropertiesResponse
import com.pulumi.azurenative.elastic.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.elastic.kotlin.outputs.MonitoringTagRulesPropertiesResponse.Companion.toKotlin as monitoringTagRulesPropertiesResponseToKotlin
import com.pulumi.azurenative.elastic.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [TagRule].
 */
@PulumiTagMarker
public class TagRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TagRuleArgs = TagRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TagRuleArgsBuilder.() -> Unit) {
        val builder = TagRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TagRule {
        val builtJavaResource = com.pulumi.azurenative.elastic.TagRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TagRule(builtJavaResource)
    }
}

/**
 * Capture logs and metrics of Azure resources based on ARM tags.
 * Azure REST API version: 2023-06-01. Prior API version in Azure Native 1.x: 2020-07-01.
 * Other available API versions: 2023-06-15-preview, 2023-07-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### TagRules_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tagRule = new AzureNative.Elastic.TagRule("tagRule", new()
 *     {
 *         MonitorName = "myMonitor",
 *         ResourceGroupName = "myResourceGroup",
 *         RuleSetName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elastic/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elastic.NewTagRule(ctx, "tagRule", &elastic.TagRuleArgs{
 * 			MonitorName:       pulumi.String("myMonitor"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			RuleSetName:       pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elastic.TagRule;
 * import com.pulumi.azurenative.elastic.TagRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tagRule = new TagRule("tagRule", TagRuleArgs.builder()
 *             .monitorName("myMonitor")
 *             .resourceGroupName("myResourceGroup")
 *             .ruleSetName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:elastic:TagRule default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Elastic/monitors/{monitorName}/tagRules/{ruleSetName}
 * ```
 */
public class TagRule internal constructor(
    override val javaResource: com.pulumi.azurenative.elastic.TagRule,
) : KotlinCustomResource(javaResource, TagRuleMapper) {
    /**
     * Name of the rule set.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of the monitoring tag rules.
     */
    public val properties: Output<MonitoringTagRulesPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                monitoringTagRulesPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The system metadata relating to this resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the rule set.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object TagRuleMapper : ResourceMapper<TagRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.elastic.TagRule::class == javaResource::class

    override fun map(javaResource: Resource): TagRule = TagRule(
        javaResource as
            com.pulumi.azurenative.elastic.TagRule,
    )
}

/**
 * @see [TagRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TagRule].
 */
public suspend fun tagRule(name: String, block: suspend TagRuleResourceBuilder.() -> Unit):
    TagRule {
    val builder = TagRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TagRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tagRule(name: String): TagRule {
    val builder = TagRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
