@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.inputs

import com.pulumi.azurenative.elastic.inputs.GetOrganizationApiKeyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property emailId The User email Id
 */
public data class GetOrganizationApiKeyPlainArgs(
    public val emailId: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elastic.inputs.GetOrganizationApiKeyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.elastic.inputs.GetOrganizationApiKeyPlainArgs =
        com.pulumi.azurenative.elastic.inputs.GetOrganizationApiKeyPlainArgs.builder()
            .emailId(emailId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOrganizationApiKeyPlainArgs].
 */
@PulumiTagMarker
public class GetOrganizationApiKeyPlainArgsBuilder internal constructor() {
    private var emailId: String? = null

    /**
     * @param value The User email Id
     */
    @JvmName("jginptfoospjyjgi")
    public suspend fun emailId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.emailId = mapped
    }

    internal fun build(): GetOrganizationApiKeyPlainArgs = GetOrganizationApiKeyPlainArgs(
        emailId = emailId,
    )
}
