@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.inputs

import com.pulumi.azurenative.elastic.inputs.MonitoringTagRulesPropertiesArgs.builder
import com.pulumi.azurenative.elastic.kotlin.enums.ProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Definition of the properties for a TagRules resource.
 * @property logRules Rules for sending logs.
 * @property provisioningState Provisioning state of the monitoring tag rules.
 */
public data class MonitoringTagRulesPropertiesArgs(
    public val logRules: Output<LogRulesArgs>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elastic.inputs.MonitoringTagRulesPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.elastic.inputs.MonitoringTagRulesPropertiesArgs =
        com.pulumi.azurenative.elastic.inputs.MonitoringTagRulesPropertiesArgs.builder()
            .logRules(logRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [MonitoringTagRulesPropertiesArgs].
 */
@PulumiTagMarker
public class MonitoringTagRulesPropertiesArgsBuilder internal constructor() {
    private var logRules: Output<LogRulesArgs>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    /**
     * @param value Rules for sending logs.
     */
    @JvmName("mgxxtpixfcihxxcd")
    public suspend fun logRules(`value`: Output<LogRulesArgs>) {
        this.logRules = value
    }

    /**
     * @param value Provisioning state of the monitoring tag rules.
     */
    @JvmName("cwileycaptiptpmi")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value Rules for sending logs.
     */
    @JvmName("ptjffitjjuuiqvlm")
    public suspend fun logRules(`value`: LogRulesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logRules = mapped
    }

    /**
     * @param argument Rules for sending logs.
     */
    @JvmName("gwhawvoqscushmqf")
    public suspend fun logRules(argument: suspend LogRulesArgsBuilder.() -> Unit) {
        val toBeMapped = LogRulesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logRules = mapped
    }

    /**
     * @param value Provisioning state of the monitoring tag rules.
     */
    @JvmName("foicebvtjiaxtbvb")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the monitoring tag rules.
     */
    @JvmName("cqeltxqwbgpohava")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the monitoring tag rules.
     */
    @JvmName("rgxofqkhvidjlmig")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    internal fun build(): MonitoringTagRulesPropertiesArgs = MonitoringTagRulesPropertiesArgs(
        logRules = logRules,
        provisioningState = provisioningState,
    )
}
