@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Elastic traffic filter object
 * @property description Description of the elastic filter
 * @property id Id of the elastic filter
 * @property includeByDefault IncludeByDefault for the elastic filter
 * @property name Name of the elastic filter
 * @property region Region of the elastic filter
 * @property rules Rules in the elastic filter
 * @property type Type of the elastic filter
 */
public data class ElasticTrafficFilterResponse(
    public val description: String? = null,
    public val id: String? = null,
    public val includeByDefault: Boolean? = null,
    public val name: String? = null,
    public val region: String? = null,
    public val rules: List<ElasticTrafficFilterRuleResponse>? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.ElasticTrafficFilterResponse):
            ElasticTrafficFilterResponse = ElasticTrafficFilterResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            includeByDefault = javaType.includeByDefault().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.elastic.kotlin.outputs.ElasticTrafficFilterRuleResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
