@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Identity properties.
 * @property principalId The identity ID.
 * @property tenantId The tenant ID of resource.
 * @property type Managed identity type.
 */
public data class IdentityPropertiesResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.elastic.outputs.IdentityPropertiesResponse):
            IdentityPropertiesResponse = IdentityPropertiesResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
