@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.inputs

import com.pulumi.azurenative.elasticsan.inputs.NetworkRuleSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A set of rules governing the network accessibility.
 * @property virtualNetworkRules The list of virtual network rules.
 */
public data class NetworkRuleSetArgs(
    public val virtualNetworkRules: Output<List<VirtualNetworkRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elasticsan.inputs.NetworkRuleSetArgs> {
    override fun toJava(): com.pulumi.azurenative.elasticsan.inputs.NetworkRuleSetArgs =
        com.pulumi.azurenative.elasticsan.inputs.NetworkRuleSetArgs.builder()
            .virtualNetworkRules(
                virtualNetworkRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkRuleSetArgs].
 */
@PulumiTagMarker
public class NetworkRuleSetArgsBuilder internal constructor() {
    private var virtualNetworkRules: Output<List<VirtualNetworkRuleArgs>>? = null

    /**
     * @param value The list of virtual network rules.
     */
    @JvmName("kdxabiyyjypauiqo")
    public suspend fun virtualNetworkRules(`value`: Output<List<VirtualNetworkRuleArgs>>) {
        this.virtualNetworkRules = value
    }

    @JvmName("ertwaeqqcineuspv")
    public suspend fun virtualNetworkRules(vararg values: Output<VirtualNetworkRuleArgs>) {
        this.virtualNetworkRules = Output.all(values.asList())
    }

    /**
     * @param values The list of virtual network rules.
     */
    @JvmName("twsxmdwsaattlnxs")
    public suspend fun virtualNetworkRules(values: List<Output<VirtualNetworkRuleArgs>>) {
        this.virtualNetworkRules = Output.all(values)
    }

    /**
     * @param value The list of virtual network rules.
     */
    @JvmName("lbkxontbxexyocub")
    public suspend fun virtualNetworkRules(`value`: List<VirtualNetworkRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument The list of virtual network rules.
     */
    @JvmName("pcgpjhytstmqdrxm")
    public suspend
    fun virtualNetworkRules(argument: List<suspend VirtualNetworkRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument The list of virtual network rules.
     */
    @JvmName("nggyjrfiqawxosom")
    public suspend fun virtualNetworkRules(
        vararg
        argument: suspend VirtualNetworkRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param argument The list of virtual network rules.
     */
    @JvmName("ktsolbaqxjwuobjv")
    public suspend
    fun virtualNetworkRules(argument: suspend VirtualNetworkRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VirtualNetworkRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.virtualNetworkRules = mapped
    }

    /**
     * @param values The list of virtual network rules.
     */
    @JvmName("khmdxwlkqonykuhi")
    public suspend fun virtualNetworkRules(vararg values: VirtualNetworkRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualNetworkRules = mapped
    }

    internal fun build(): NetworkRuleSetArgs = NetworkRuleSetArgs(
        virtualNetworkRules = virtualNetworkRules,
    )
}
