@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Data used when creating a volume snapshot.
 * @property sourceId Fully qualified resource ID of the volume. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}/volumes/{volumeName}"
 */
public data class SnapshotCreationDataResponse(
    public val sourceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.elasticsan.outputs.SnapshotCreationDataResponse):
            SnapshotCreationDataResponse = SnapshotCreationDataResponse(
            sourceId = javaType.sourceId(),
        )
    }
}
