@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.engagementfabric.kotlin.inputs

import com.pulumi.azurenative.engagementfabric.inputs.SKUArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The EngagementFabric SKU
 * @property name The name of the SKU
 * @property tier The price tier of the SKU
 */
public data class SKUArgs(
    public val name: Output<String>,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.engagementfabric.inputs.SKUArgs> {
    override fun toJava(): com.pulumi.azurenative.engagementfabric.inputs.SKUArgs =
        com.pulumi.azurenative.engagementfabric.inputs.SKUArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SKUArgs].
 */
@PulumiTagMarker
public class SKUArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value The name of the SKU
     */
    @JvmName("bwlgquvlklrwejni")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The price tier of the SKU
     */
    @JvmName("vpxebyesctrlvvce")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value The name of the SKU
     */
    @JvmName("crthpglvmtmlnlna")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The price tier of the SKU
     */
    @JvmName("bdyvvsucktyrhbon")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SKUArgs = SKUArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        tier = tier,
    )
}
